/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc.utils;

public class TimeUtils {
    private static final double J0 = 9.0E-4;

    public static double getJulianCycle(double d, double lw) {
        return Math.round(d - 9.0E-4 - lw / (Math.PI * 2));
    }

    public static double getApproxTransit(double Ht, double lw, double n) {
        return 9.0E-4 + (Ht + lw) / (Math.PI * 2) + n;
    }

    public static double getSolarTransitJ(double ds, double M, double L) {
        return 2451545.0 + ds + 0.0053 * Math.sin(M) - 0.0069 * Math.sin(2.0 * L);
    }

    public static double getHourAngle(double h, double phi, double d) {
        return Math.acos((Math.sin(h) - Math.sin(phi) * Math.sin(d)) / (Math.cos(phi) * Math.cos(d)));
    }
}

