/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc.utils;

import com.florianmski.suncalc.models.EquatorialCoordinates;
import com.florianmski.suncalc.utils.PositionUtils;

public class SunUtils {
    public static double getSolarMeanAnomaly(double d) {
        return Math.PI / 180 * (357.5291 + 0.98560028 * d);
    }

    public static double getEquationOfCenter(double M) {
        return Math.PI / 180 * (1.9148 * Math.sin(M) + 0.02 * Math.sin(2.0 * M) + 3.0E-4 * Math.sin(3.0 * M));
    }

    public static double getEclipticLongitude(double M, double C) {
        double P = 1.796593062783907;
        return M + C + P + Math.PI;
    }

    public static EquatorialCoordinates getSunCoords(double d) {
        double M = SunUtils.getSolarMeanAnomaly(d);
        double C = SunUtils.getEquationOfCenter(M);
        double L = SunUtils.getEclipticLongitude(M, C);
        return new EquatorialCoordinates(PositionUtils.getRightAscension(L, 0.0), PositionUtils.getDeclination(L, 0.0));
    }
}

