/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc.utils;

import com.florianmski.suncalc.models.GeocentricCoordinates;
import com.florianmski.suncalc.utils.PositionUtils;

public class MoonUtils {
    public static GeocentricCoordinates getMoonCoords(double d) {
        double L = Math.PI / 180 * (218.316 + 13.176396 * d);
        double M = Math.PI / 180 * (134.963 + 13.064993 * d);
        double F = Math.PI / 180 * (93.272 + 13.22935 * d);
        double l = L + 0.10976375665792339 * Math.sin(M);
        double b = 0.08950048404226922 * Math.sin(F);
        double dt = 385001.0 - 20905.0 * Math.cos(M);
        return new GeocentricCoordinates(PositionUtils.getRightAscension(l, b), PositionUtils.getDeclination(l, b), dt);
    }
}

