/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc.utils;

import java.util.Calendar;

public class DateUtils {
    public static final int DAY_MS = 86400000;
    public static final int J1970 = 2440588;
    public static final int J2000 = 2451545;

    public static double toJulian(Calendar date) {
        long offset = date.getTimeZone().getOffset(date.getTimeInMillis());
        return ((double)date.getTimeInMillis() + (double)offset) / 8.64E7 - 0.5 + 2440588.0;
    }

    public static Calendar fromJulian(double j) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis((long)((j + 0.5 - 2440588.0) * 8.64E7));
        return date;
    }

    public static double toDays(Calendar date) {
        return DateUtils.toJulian(date) - 2451545.0;
    }
}

