/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc.models;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SunPhase {
    private Name name;
    private double startAngle;
    private double endAngle;
    private boolean startRise;
    private boolean endRise;
    private Calendar startDate;
    private Calendar endDate;

    private SunPhase(Name name, double startAngle, boolean startRise, double endAngle, boolean endRise) {
        this.name = name;
        this.startAngle = startAngle;
        this.startRise = startRise;
        this.endAngle = endAngle;
        this.endRise = endRise;
    }

    public static SunPhase get(Name name) {
        switch (name) {
            case SUNRISE: {
                return new SunPhase(name, -0.833, true, -0.3, true);
            }
            case GOLDEN_HOUR_MORNING: {
                return new SunPhase(name, -0.3, true, 6.0, true);
            }
            case DAYLIGHT: {
                return new SunPhase(name, 6.0, true, 6.0, false);
            }
            case GOLDEN_HOUR_EVENING: {
                return new SunPhase(name, 6.0, false, -0.3, false);
            }
            case SUNSET: {
                return new SunPhase(name, -0.3, false, -0.833, false);
            }
            case TWILIGHT_ASTRONOMICAL_EVENING: {
                return new SunPhase(name, -12.0, false, -18.0, false);
            }
            case TWILIGHT_NAUTICAL_EVENING: {
                return new SunPhase(name, -6.0, false, -12.0, false);
            }
            case TWILIGHT_CIVIL_EVENING: {
                return new SunPhase(name, -0.833, false, -6.0, false);
            }
            case NIGHT_EVENING: {
                return new SunPhase(name, -18.0, false, -18.0, true);
            }
            case NIGHT_MORNING: {
                return new SunPhase(name, -18.0, false, -18.0, true);
            }
            case TWILIGHT_CIVIL_MORNING: {
                return new SunPhase(name, -6.0, true, -0.833, true);
            }
            case TWILIGHT_NAUTICAL_MORNING: {
                return new SunPhase(name, -12.0, true, -6.0, true);
            }
            case TWILIGHT_ASTRONOMICAL_MORNING: {
                return new SunPhase(name, -18.0, true, -12.0, true);
            }
        }
        throw new InvalidParameterException(name.value + " is not supported");
    }

    public static List<SunPhase> all() {
        ArrayList<SunPhase> results = new ArrayList<SunPhase>();
        for (Name n : Name.values()) {
            results.add(SunPhase.get(n));
        }
        return results;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isStartRise() {
        return this.startRise;
    }

    public boolean isEndRise() {
        return this.endRise;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public Calendar getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Calendar startDate) {
        this.startDate = startDate;
    }

    public Calendar getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Calendar endDate) {
        this.endDate = endDate;
    }

    public static enum Name {
        NIGHT_MORNING("Night"),
        TWILIGHT_ASTRONOMICAL_MORNING("Twilight Astronomical"),
        TWILIGHT_NAUTICAL_MORNING("Twilight Nautical"),
        TWILIGHT_CIVIL_MORNING("Twilight Civil"),
        SUNRISE("Sunrise"),
        GOLDEN_HOUR_MORNING("Golden Hour"),
        DAYLIGHT("Daylight"),
        GOLDEN_HOUR_EVENING("Golden Hour"),
        SUNSET("Sunset"),
        TWILIGHT_CIVIL_EVENING("Twilight Civil"),
        TWILIGHT_NAUTICAL_EVENING("Twilight Nautical"),
        TWILIGHT_ASTRONOMICAL_EVENING("Twilight Astronomical"),
        NIGHT_EVENING("Night");

        private final String value;
        private static final Map<String, Name> STRING_MAPPING;

        private Name(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static Name fromValue(String value) {
            return STRING_MAPPING.get(value.toUpperCase());
        }

        static {
            STRING_MAPPING = new HashMap<String, Name>();
            for (Name via : Name.values()) {
                STRING_MAPPING.put(via.toString().toUpperCase(), via);
            }
        }
    }
}

