/*
 * Decompiled with CFR 0.152.
 */
package com.florianmski.suncalc;

import com.florianmski.suncalc.models.EquatorialCoordinates;
import com.florianmski.suncalc.models.GeocentricCoordinates;
import com.florianmski.suncalc.models.MoonPosition;
import com.florianmski.suncalc.models.SunPhase;
import com.florianmski.suncalc.models.SunPosition;
import com.florianmski.suncalc.utils.DateUtils;
import com.florianmski.suncalc.utils.MoonUtils;
import com.florianmski.suncalc.utils.PositionUtils;
import com.florianmski.suncalc.utils.SunUtils;
import com.florianmski.suncalc.utils.TimeUtils;
import java.util.Calendar;
import java.util.List;

public class SunCalc {
    public static SunPosition getSunPosition(Calendar date, double lat, double lng) {
        double lw = Math.PI / 180 * -lng;
        double phi = Math.PI / 180 * lat;
        double d = DateUtils.toDays(date);
        EquatorialCoordinates c = SunUtils.getSunCoords(d);
        double H = PositionUtils.getSiderealTime(d, lw) - c.getRightAscension();
        return new SunPosition(PositionUtils.getAzimuth(H, phi, c.getDeclination()), PositionUtils.getAltitude(H, phi, c.getDeclination()));
    }

    public static MoonPosition getMoonPosition(Calendar date, double lat, double lng) {
        double lw = Math.PI / 180 * -lng;
        double phi = Math.PI / 180 * lat;
        double d = DateUtils.toDays(date);
        GeocentricCoordinates c = MoonUtils.getMoonCoords(d);
        double H = PositionUtils.getSiderealTime(d, lw) - c.getRightAscension();
        double h = PositionUtils.getAltitude(H, phi, c.getDeclination());
        h += 2.96705972839036E-4 / Math.tan(h + 0.1790707812546182 / (h + 0.0890117918517108));
        return new MoonPosition(PositionUtils.getAzimuth(H, phi, c.getDeclination()), h, c.getDistance());
    }

    public static double getMoonFraction(Calendar date) {
        double d = DateUtils.toDays(date);
        EquatorialCoordinates s = SunUtils.getSunCoords(d);
        GeocentricCoordinates m = MoonUtils.getMoonCoords(d);
        int sdist = 149598000;
        double phi = Math.acos(Math.sin(s.getDeclination()) * Math.sin(m.getDeclination()) + Math.cos(s.getDeclination()) * Math.cos(m.getDeclination()) * Math.cos(s.getRightAscension() - m.getRightAscension()));
        double inc = Math.atan2((double)sdist * Math.sin(phi), m.getDistance() - (double)sdist * Math.cos(phi));
        return (1.0 + Math.cos(inc)) / 2.0;
    }

    public static List<SunPhase> getPhases(Calendar date, double lat, double lng) {
        double lw = Math.PI / 180 * -lng;
        double phi = Math.PI / 180 * lat;
        double d = DateUtils.toDays(date);
        double n = TimeUtils.getJulianCycle(d, lw);
        double ds = TimeUtils.getApproxTransit(0.0, lw, n);
        double M = SunUtils.getSolarMeanAnomaly(ds);
        double C = SunUtils.getEquationOfCenter(M);
        double L = SunUtils.getEclipticLongitude(M, C);
        double dec = PositionUtils.getDeclination(L, 0.0);
        double jnoon = TimeUtils.getSolarTransitJ(ds, M, L);
        List<SunPhase> results = SunPhase.all();
        for (SunPhase sunPhase : results) {
            sunPhase.setStartDate(SunCalc.getPhaseDate(sunPhase.getStartAngle(), sunPhase.isStartRise(), jnoon, phi, dec, lw, n, M, L));
            sunPhase.setEndDate(SunCalc.getPhaseDate(sunPhase.getEndAngle(), sunPhase.isEndRise(), jnoon, phi, dec, lw, n, M, L));
        }
        Calendar nightMorningStartDate = (Calendar)date.clone();
        nightMorningStartDate.set(11, 0);
        nightMorningStartDate.set(12, 0);
        nightMorningStartDate.set(13, 0);
        nightMorningStartDate.set(14, 0);
        results.get(0).setStartDate(nightMorningStartDate);
        Calendar nightEveningEndDate = (Calendar)date.clone();
        nightEveningEndDate.set(11, 23);
        nightEveningEndDate.set(12, 59);
        nightEveningEndDate.set(13, 59);
        nightEveningEndDate.set(14, 999);
        results.get(results.size() - 1).setEndDate(nightEveningEndDate);
        return results;
    }

    private static Calendar getPhaseDate(double angle, boolean rising, double jnoon, double phi, double dec, double lw, double n, double M, double L) {
        double h = angle * (Math.PI / 180);
        double w = TimeUtils.getHourAngle(h, phi, dec);
        double a = TimeUtils.getApproxTransit(w, lw, n);
        double jset = TimeUtils.getSolarTransitJ(a, M, L);
        if (rising) {
            double jrise = jnoon - (jset - jnoon);
            return DateUtils.fromJulian(jrise);
        }
        return DateUtils.fromJulian(jset);
    }
}

