/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.processing.presence.util;

import at.creadoo.homer.processing.presence.Constants;
import at.creadoo.homer.processing.presence.util.Util;
import com.florianmski.suncalc.SunCalc;
import com.florianmski.suncalc.models.SunPhase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class WeatherUtil {
    private static final Logger log = Logger.getLogger(WeatherUtil.class);

    public static final Map<String, String> fetchVariables(Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("sunrise", Util.getProperty(properties, "weather.fallback.sunrise"));
        result.put("sunset", Util.getProperty(properties, "weather.fallback.sunset"));
        String weatherLat = Util.getProperty(properties, "weather.lat");
        String weatherLon = Util.getProperty(properties, "weather.lon");
        if (weatherLat == null || weatherLat.trim().isEmpty() || weatherLon == null || weatherLon.trim().isEmpty()) {
            return result;
        }
        Double weatherLatValue = null;
        Double weatherLonValue = null;
        try {
            weatherLatValue = Double.parseDouble(weatherLat.trim());
            weatherLonValue = Double.parseDouble(weatherLon.trim());
        }
        catch (NumberFormatException ex) {
            return result;
        }
        if (weatherLatValue == null || weatherLonValue == null) {
            return result;
        }
        List<SunPhase> phases = SunCalc.getPhases(DateTime.now().toGregorianCalendar(), weatherLatValue, weatherLonValue);
        for (SunPhase phase : phases) {
            if (phase.getName().equals((Object)SunPhase.Name.SUNRISE)) {
                LocalTime sunrise = new LocalDateTime((Object)phase.getStartDate()).toLocalTime();
                log.debug((Object)("sunrise".toUpperCase() + ": " + sunrise));
                if (sunrise != null) {
                    result.put("sunrise", Constants.TIME_FORMAT.print((ReadablePartial)sunrise));
                    continue;
                }
                log.error((Object)"Error retrieving data for 'sunrise' from service");
                continue;
            }
            if (!phase.getName().equals((Object)SunPhase.Name.SUNSET)) continue;
            LocalTime sunset = new LocalDateTime((Object)phase.getStartDate()).toLocalTime();
            log.debug((Object)("sunset".toUpperCase() + ": " + sunset));
            if (sunset != null) {
                result.put("sunset", Constants.TIME_FORMAT.print((ReadablePartial)sunset));
                continue;
            }
            log.error((Object)"Error retrieving data for 'sunset' from service");
        }
        return result;
    }
}

