/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.processing.presence.util;

import at.ac.ait.hbs.homer.core.common.util.PropertyUtil;
import at.creadoo.homer.processing.presence.Constants;
import com.udojava.evalex.Expression;
import java.math.BigDecimal;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class);

    public static Map<String, String> toMap(Dictionary<String, ?> dictionary) {
        if (dictionary == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>(dictionary.size());
        Enumeration<String> keys = dictionary.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            map.put(key, dictionary.get(key).toString());
        }
        return map;
    }

    public static Map<String, String> matchingSubset(Map<String, String> properties, String prefix, boolean keepPrefix) {
        String prefixMatch;
        String prefixSelf;
        HashMap<String, String> result = new HashMap<String, String>();
        if (prefix == null || prefix.length() == 0) {
            return result;
        }
        if (prefix.charAt(prefix.length() - 1) != '.') {
            prefixSelf = prefix;
            prefixMatch = prefix + '.';
        } else {
            prefixSelf = prefix.substring(0, prefix.length() - 1);
            prefixMatch = prefix;
        }
        for (String key : properties.keySet()) {
            if (keepPrefix) {
                if (!key.startsWith(prefixMatch) && !key.equals(prefixSelf)) continue;
                result.put(key, properties.get(key));
                continue;
            }
            if (!key.startsWith(prefixMatch)) continue;
            result.put(key.substring(prefixMatch.length()), properties.get(key));
        }
        return result;
    }

    public static String getProperty(Map<String, String> properties, String key) {
        log.debug((Object)("Get value for '" + key + "' from: " + properties));
        if (properties != null && properties.keySet().contains(key)) {
            return PropertyUtil.sanitizeValue((String)properties.get(key));
        }
        return "";
    }

    public static void replaceProperty(Map<String, String> properties, String target, String replacement) {
        for (String key : properties.keySet()) {
            String item = properties.get(key);
            if (!item.contains(target)) continue;
            properties.put(key, item.replace(target, replacement));
        }
    }

    public static String prepareProperty(String property) {
        if (property == null || property.trim().isEmpty()) {
            return "";
        }
        String temp = property.trim();
        temp = temp.trim().replace(" ", "");
        String valueToReplace = Util.getContentsInBrackets(temp);
        while (valueToReplace != null) {
            try {
                Expression expr = new Expression(Util.convertTimesToInt(valueToReplace));
                BigDecimal evaluatedValueToReplace = expr.eval();
                String replacement = Util.printTimeFromInt(evaluatedValueToReplace);
                temp = temp.replace(valueToReplace, replacement);
                valueToReplace = Util.getContentsInBrackets(temp, temp.indexOf(replacement) + replacement.length());
            }
            catch (Throwable ex) {
                log.error((Object)("Error evaluating expression '" + valueToReplace + "'"));
                valueToReplace = Util.getContentsInBrackets(temp, temp.indexOf(valueToReplace) + valueToReplace.length());
            }
        }
        return temp;
    }

    private static int getMinutesSinceMidnight(LocalTime time) {
        return time.get(DateTimeFieldType.minuteOfDay());
    }

    private static String printTimeFromInt(BigDecimal value) {
        return Util.printTimeFromInt(value.intValue());
    }

    private static String printTimeFromInt(int value) {
        return Constants.TIME_FORMAT.print((ReadablePartial)Util.timeFromInt(value));
    }

    private static LocalTime timeFromInt(int minutesSinceMidnight) {
        return LocalTime.fromMillisOfDay((long)(minutesSinceMidnight * 60 * 1000));
    }

    private static String getContentsInBrackets(String value) {
        return Util.getContentsInBrackets(value, 0);
    }

    private static String getContentsInBrackets(String value, int fromIndex) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        int openPos = value.trim().indexOf("(", fromIndex);
        if (openPos >= 0) {
            String valueTemp = value.trim();
            int openCounter = 1;
            for (int i = openPos + 1; i < valueTemp.length(); ++i) {
                if (valueTemp.charAt(i) == '(') {
                    ++openCounter;
                } else if (valueTemp.charAt(i) == ')') {
                    --openCounter;
                }
                if (openCounter != 0) continue;
                return value.trim().substring(openPos, i + 1);
            }
        }
        return null;
    }

    private static String convertTimesToInt(String value) {
        Pattern pattern = Pattern.compile("(\\d\\d:\\d\\d)");
        Matcher matcher = pattern.matcher(value);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            LocalTime time = Constants.parseTime(matcher.group());
            if (time != null) {
                matcher.appendReplacement(result, Integer.toString(Util.getMinutesSinceMidnight(time)));
                continue;
            }
            matcher.appendReplacement(result, matcher.group());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static LocalTime getStartTime(String time) {
        if (time == null || time.trim().isEmpty()) {
            return null;
        }
        String tempTime = time.trim();
        if (tempTime.contains("+")) {
            tempTime = tempTime.substring(0, time.indexOf("+"));
        } else if (time.contains("-")) {
            tempTime = tempTime.substring(0, time.indexOf("-"));
        }
        try {
            return Constants.parseTime(tempTime);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static LocalTime getEndTime(String time) {
        LocalTime startTime = Util.getStartTime(time);
        if (time == null || time.isEmpty()) {
            return null;
        }
        if (time.contains("+") && startTime != null) {
            return startTime.plusMinutes(Integer.parseInt(time.substring(time.indexOf("+") + 1)));
        }
        if (time.contains("-")) {
            try {
                return Constants.parseTime(time.substring(time.indexOf("-") + 1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

