package at.creadoo.homer.processing.presence.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;

import com.florianmski.suncalc.SunCalc;
import com.florianmski.suncalc.models.SunPhase;
import com.florianmski.suncalc.models.SunPhase.Name;

import at.creadoo.homer.processing.presence.Constants;

public class WeatherUtil {

	private static final Logger log = Logger.getLogger(WeatherUtil.class);

	public WeatherUtil() {
		//
	}
	
	public static final Map<String, String> fetchVariables(final Map<String, String> properties) {
		final Map<String, String> result = new HashMap<String, String>();
		
		// Set defaults
		result.put(Constants.VARIABLE_KEY_SUNRISE, Util.getProperty(properties, Constants.KEY_WEATHER_FALLBACK_SUNRISE));
		result.put(Constants.VARIABLE_KEY_SUNSET, Util.getProperty(properties, Constants.KEY_WEATHER_FALLBACK_SUNSET));

		final String weatherLat = Util.getProperty(properties, Constants.KEY_WEATHER_LATITUDE);
		final String weatherLon = Util.getProperty(properties, Constants.KEY_WEATHER_LONGITUDE);
		if (weatherLat == null || weatherLat.trim().isEmpty() || weatherLon == null || weatherLon.trim().isEmpty()) {
			return result;
		}
		
		Double weatherLatValue = null;
		Double weatherLonValue = null;
		try {
			weatherLatValue = Double.parseDouble(weatherLat.trim());
			weatherLonValue = Double.parseDouble(weatherLon.trim());
		} catch (NumberFormatException ex) {
			return result;
		}
		
		if (weatherLatValue == null || weatherLonValue == null) {
			return result;
		}
		
		final List<SunPhase> phases = SunCalc.getPhases(DateTime.now().toGregorianCalendar(), weatherLatValue, weatherLonValue);
		for (SunPhase phase : phases) {
			if (phase.getName().equals(Name.SUNRISE)) {
				final LocalTime sunrise = new LocalDateTime(phase.getStartDate()).toLocalTime();
				log.debug(Constants.VARIABLE_KEY_SUNRISE.toUpperCase() + ": " + sunrise);
				if (sunrise != null) {
					result.put(Constants.VARIABLE_KEY_SUNRISE, Constants.TIME_FORMAT.print(sunrise));
				} else {
					log.error("Error retrieving data for '" + Constants.VARIABLE_KEY_SUNRISE + "' from service");
				}
			} else if (phase.getName().equals(Name.SUNSET)) {
				final LocalTime sunset = new LocalDateTime(phase.getStartDate()).toLocalTime();
				log.debug(Constants.VARIABLE_KEY_SUNSET.toUpperCase() + ": " + sunset);
				if (sunset != null) {
					result.put(Constants.VARIABLE_KEY_SUNSET, Constants.TIME_FORMAT.print(sunset));
				} else {
					log.error("Error retrieving data for '" + Constants.VARIABLE_KEY_SUNSET + "' from service");
				}
			}
		}
		
		return result;
	}

}
