package at.creadoo.homer.processing.presence.model;

import java.io.Serializable;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import at.ac.ait.hbs.homer.core.common.enumerations.DeviceMessageType;
import at.ac.ait.hbs.homer.core.common.model.DBDevice;

/**
 * Model class holding information sent in the sub profile
 * 
 * @author roedll
 *
 */
public class SensorItem implements Serializable, Cloneable {

	private static final long serialVersionUID = 1L;
	
	private DBDevice device = null;
	
	private DeviceMessageType deviceMessageType = null;
	
	private boolean on = false;
    
    public SensorItem() {
    	//
    }
    
    public SensorItem(final DBDevice device, final DeviceMessageType deviceMessageType) {
    	setDevice(device);
    	setDeviceMessageType(deviceMessageType);
    }
    
    public SensorItem(final DBDevice device, final DeviceMessageType deviceMessageType, final boolean on) {
    	this(device, deviceMessageType);
    	setOn(on);
    }

	public DBDevice getDevice() {
		return device;
	}

	public void setDevice(final DBDevice device) {
		this.device = device;
	}

	public DeviceMessageType getDeviceMessageType() {
		return deviceMessageType;
	}

	public void setDeviceMessageType(final DeviceMessageType deviceMessageType) {
		this.deviceMessageType = deviceMessageType;
	}

    public boolean getOn() {
		return on;
	}

	public void setOn(final boolean on) {
		this.on = on;
	}

	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(final Object other) {
        return EqualsBuilder.reflectionEquals(this, other);
    }

    @Override
    public String toString() {
    	return ToStringBuilder.reflectionToString(this);
    }

}
