package at.creadoo.homer.processing.presence;

import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;

public final class Constants {

	public static final String CONFIG_PID = "at.creadoo.homer.processing.presence";

	public static final String CONFIGURATION_KEY_ENABLED = CONFIG_PID + ".enabled";

	public static final String KEY_INITIAL_ENABLED = "initial.enabled";

	public static final String KEY_RECALCULATION_TIME = "recalculation.time";

	public static final String KEY_WEATHER_LATITUDE = "weather.lat";

	public static final String KEY_WEATHER_LONGITUDE = "weather.lon";

	public static final String KEY_WEATHER_FALLBACK_SUNRISE = "weather.fallback.sunrise";

	public static final String KEY_WEATHER_FALLBACK_SUNSET = "weather.fallback.sunset";

	public static final String KEY_PREFIX_ACTUATOR = "actuator.";

	public static final String KEY_PREFIX_SENSOR = "sensor.";

	public static final String VARIABLE_KEY_SUNRISE = "sunrise";

	public static final String VARIABLE_KEY_SUNSET = "sunset";

	public static final int SECONDS_PER_DAY = 60 * 60 * 24;

	public static final DateTimeFormatter TIME_FORMAT = DateTimeFormat.forPattern("HH:mm");
	
	protected static final DateTimeFormatter TIME_PARSER;
	
	static {
		TIME_PARSER = new DateTimeFormatterBuilder().append(null, // because no printing is required
			new DateTimeParser[] {
				TIME_FORMAT.getParser()
			}
		).toFormatter();
	}
	
	private Constants() {
		//
	}
	
	public static LocalTime parseTime(final String time) {
		try {
			return TIME_PARSER.parseLocalTime(time);
		} catch (Throwable ex) {
			//
		}
		return null;
	}

}
