package at.creadoo.homer.processing.data.listeners;

import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract interface ListenerForEstimateValueHandler<T> {
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId);
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId, int... excludedDeviceIds);
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId, List<Integer> excludedDevices);
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	void addListenerForEstimateValue(ValueChangeListener<T> listener, int flatId, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDeviceIds);
	
	void removeListener(ValueChangeListener<T> listener);
	
	void removeListenerForEstimateValue(ValueChangeListener<T> listener);

}