package at.creadoo.homer.processing.data.listeners;

import java.util.List;
import java.util.concurrent.TimeUnit;

import at.creadoo.homer.processing.data.enumerations.AverageCalculationMode;

public abstract interface ListenerForAverageValueHandler<T> {
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId);
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId, int... excludedDeviceIds);
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId, List<Integer> excludedDevices);
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	void addListenerForAverageValue(ValueChangeListener<T> listener, AverageCalculationMode mode, int flatId, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDeviceIds);
	
	void removeListener(ValueChangeListener<T> listener);
	
	void removeListenerForAverageValue(ValueChangeListener<T> listener);

}