package at.creadoo.homer.processing.data.impl;

import java.util.Iterator;
import java.util.List;

import at.creadoo.homer.processing.data.enumerations.CalculationMode;
import at.creadoo.homer.processing.data.listeners.ValueChangeListener;

public class ListenerUtil {

	private ListenerUtil() {
		//
	}

	public static final <T> boolean containsListener(final List<ValueChangeListenerItem<T>> listeners, final ValueChangeListener<T> listener) {
		if (listener == null) {
			return false;
		}
		
		for (ValueChangeListenerItem<T> item : listeners) {
			if (item.getListener().equals(listener)) {
				return true;
			}
		}
		return false;
	}

	public static final <T> void removeListener(final List<ValueChangeListenerItem<T>> listeners, final ValueChangeListener<T> listener) {
		if (listener == null) {
			return;
		}
		
		for (Iterator<ValueChangeListenerItem<T>> iterator = listeners.iterator(); iterator.hasNext();) {
			ValueChangeListenerItem<?> item = iterator.next();
		    if (item.getListener().equals(listener)) {
		        iterator.remove();
		    }
		}
	}

	public static final <T> void removeListener(final List<ValueChangeListenerItem<T>> listeners, final ValueChangeListener<T> listener, final CalculationMode calculationMethod) {
		if (listener == null) {
			return;
		}
		
		for (Iterator<ValueChangeListenerItem<T>> iterator = listeners.iterator(); iterator.hasNext();) {
			ValueChangeListenerItem<?> item = iterator.next();
		    if (item.getListener().equals(listener) && item.getCalculationMode().equals(calculationMethod)) {
		        iterator.remove();
		    }
		}
	}

}
