package at.creadoo.homer.processing.data.enumerations;

public enum RainType {

	UNKNOWN(0),
	NONE(1),
	LIGHT(2),
	MODERATE(3),
	HEAVY(4),
	VIOLENT(5);

	private Integer id;

	private RainType(final Integer id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public static RainType getById(final Integer id) {
		for (RainType t : RainType.values()) {
			if (id.equals(t.getId())) {
				return t;
			}
		}
		return null;
	}

}