package at.creadoo.homer.processing.data.enumerations;

public enum IndoorClimateType {

	UNKNOWN(0),
	WET(1),
	COMFORTABLE(2),
	DRY(3);

	private Integer id;

	private IndoorClimateType(final Integer id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public static IndoorClimateType getById(final Integer id) {
		for (IndoorClimateType t : IndoorClimateType.values()) {
			if (id.equals(t.getId())) {
				return t;
			}
		}
		return null;
	}

}