package at.creadoo.homer.processing.data.enumerations;

public enum CalculationMode {
	
	LAST(0),
	AVERAGE(1),
	ESTIMATE(3);

	private Integer id;

	private CalculationMode(final Integer id) {
		this.id = id;
	}

	public int getId() {
		return id;
	}

	public static CalculationMode getById(final Integer id) {
		for (CalculationMode t : CalculationMode.values()) {
			if (id.equals(t.getId())) {
				return t;
			}
		}
		return null;
	}

}