package at.creadoo.homer.processing.data;

import java.util.List;
import java.util.concurrent.TimeUnit;

import at.creadoo.homer.processing.data.enumerations.AverageCalculationMode;
import at.creadoo.homer.processing.data.enumerations.RainType;

public interface RainService extends BasicService<Double> {
	
	RainType getRainType(int flatId);
	
	RainType getRainType(int flatId, List<Integer> excludedDevices);
	
	RainType getRainType(int flatId, int... excludedDeviceIds);
	
	RainType getRainType(int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	RainType getRainType(int flatId, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	RainType getRainType(int flatId, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDeviceIds);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode, List<Integer> excludedDevices);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode, int... excludedDeviceIds);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	RainType getRainType(int flatId, final AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDeviceIds);

	RainType getRainType(Double value);
	
	RainType getRainType(Double value, long calculationPeriod, TimeUnit timeUnit);
	
}
