package at.creadoo.homer.processing.data;

import java.util.concurrent.TimeUnit;

import at.creadoo.homer.processing.data.enumerations.AverageCalculationMode;
import at.creadoo.homer.processing.data.enumerations.IndoorClimateType;
import at.creadoo.homer.processing.data.listeners.ListenerForLastValueHandler;

public interface IndoorClimateService extends ListenerForLastValueHandler<IndoorClimateType> {
	
	IndoorClimateType getIndoorClimateType(int flatId);
	
	IndoorClimateType getIndoorClimateType(int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	IndoorClimateType getIndoorClimateType(int flatId, AverageCalculationMode mode);
	
	IndoorClimateType getIndoorClimateType(int flatId, AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit);
	
}
