package at.creadoo.homer.processing.data;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;

import org.joda.time.DateTime;

import at.ac.ait.hbs.homer.core.common.model.DBDevice;
import at.ac.ait.hbs.homer.core.common.model.DBMessage;
import at.creadoo.homer.processing.data.enumerations.AverageCalculationMode;
import at.creadoo.homer.processing.data.listeners.ListenerForAverageValueHandler;
import at.creadoo.homer.processing.data.listeners.ListenerForEstimateValueHandler;
import at.creadoo.homer.processing.data.listeners.ListenerForLastValueHandler;

public abstract interface BasicService<T> extends ListenerForLastValueHandler<T>, ListenerForAverageValueHandler<T>, ListenerForEstimateValueHandler<T> {
	
	List<Integer> getDeviceIds(int flatId);
	
	List<Integer> getDeviceIds(int flatId, int... excludedDeviceIds);
	
	List<Integer> getDeviceIds(int flatId, List<Integer> excludedDevices);
	
	List<Integer> getDeviceIds(Collection<DBDevice> devices);
	
	List<Integer> getDeviceIds(List<DBDevice> devices);
	
	List<Integer> getDeviceIds(int... devices);
	
	
	List<DBMessage> getDeviceMessages(int flatId);
	
	List<DBMessage> getDeviceMessages(int flatId, int... excludedDeviceIds);
	
	List<DBMessage> getDeviceMessages(int flatId, List<Integer> excludedDevices);
	
	List<DBMessage> getDeviceMessages(int flatId, long period, TimeUnit timeUnit);
	
	List<DBMessage> getDeviceMessages(int flatId, long period, TimeUnit timeUnit, int... excludedDeviceIds);
	
	List<DBMessage> getDeviceMessages(int flatId, long period, TimeUnit timeUnit, List<Integer> excludedDevices);
	

	Double getLastValue(int flatId);
	
	Double getLastValue(int flatId, int... excludedDeviceIds);
	
	Double getLastValue(int flatId, List<Integer> excludedDevices);

	Double getLastValue(int flatId, AverageCalculationMode mode);
	
	Double getLastValue(int flatId, AverageCalculationMode mode, int... excludedDeviceIds);
	
	Double getLastValue(int flatId, AverageCalculationMode mode, List<Integer> excludedDevices);

	
	Double getValue(int flatId);
	
	Double getValue(int flatId, int... excludedDeviceIds);
	
	Double getValue(int flatId, List<Integer> excludedDevices);
	
	Double getValue(int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	Double getValue(int flatId, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	Double getValue(int flatId, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDevices);
	
	Double getValue(int flatId, AverageCalculationMode mode);
	
	Double getValue(int flatId, AverageCalculationMode mode, int... excludedDeviceIds);
	
	Double getValue(int flatId, AverageCalculationMode mode, List<Integer> excludedDevices);
	
	Double getValue(int flatId, AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit);
	
	Double getValue(int flatId, AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	Double getValue(int flatId, AverageCalculationMode mode, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDevices);
	
	
	Double estimateValue(int flatId);
	
	Double estimateValue(int flatId, int... excludedDeviceIds);
	
	Double estimateValue(int flatId, List<Integer> excludedDevices);
	
	Double estimateValue(int flatId, long calculationPeriod, TimeUnit timeUnit);
	
	Double estimateValue(int flatId, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	Double estimateValue(int flatId, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDevices);
	
	Double estimateValue(int flatId, DateTime forTimestamp);
	
	Double estimateValue(int flatId, DateTime forTimestamp, int... excludedDeviceIds);
	
	Double estimateValue(int flatId, DateTime forTimestamp, List<Integer> excludedDevices);
	
	Double estimateValue(int flatId, DateTime forTimestamp, long calculationPeriod, TimeUnit timeUnit);
	
	Double estimateValue(int flatId, DateTime forTimestamp, long calculationPeriod, TimeUnit timeUnit, int... excludedDeviceIds);
	
	Double estimateValue(int flatId, DateTime forTimestamp, long calculationPeriod, TimeUnit timeUnit, List<Integer> excludedDevices);
	
}
