/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.opensprinkler;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.RaspiPin;
import java.util.Arrays;
import net.jonathangiles.opensprinkler.OpenSprinkler;

class OpenSprinklerPiGPIO
implements OpenSprinkler {
    private static final Pin SR_CLK_PIN = RaspiPin.GPIO_07;
    private static final Pin SR_NOE_PIN = RaspiPin.GPIO_00;
    private static final Pin SR_DAT_PIN = RaspiPin.GPIO_02;
    private static final Pin SR_LAT_PIN = RaspiPin.GPIO_03;
    public static boolean USE_STUB = false;
    public static boolean DEBUG_OUTPUT = false;
    private final GpioController gpio;
    private boolean[] stationState;
    private int numberOfStations;
    private final GpioPinDigitalOutput SR_CLK_OUTPUT_PIN;
    private final GpioPinDigitalOutput SR_NOE_OUTPUT_PIN;
    private final GpioPinDigitalOutput SR_DAT_OUTPUT_PIN;
    private final GpioPinDigitalOutput SR_LAT_OUTPUT_PIN;

    public OpenSprinklerPiGPIO() {
        this(8);
    }

    public OpenSprinklerPiGPIO(int stations) {
        this.stationState = new boolean[stations];
        this.setNumberOfStations(stations);
        if (USE_STUB) {
            this.gpio = null;
            this.SR_CLK_OUTPUT_PIN = null;
            this.SR_NOE_OUTPUT_PIN = null;
            this.SR_DAT_OUTPUT_PIN = null;
            this.SR_LAT_OUTPUT_PIN = null;
        } else {
            this.gpio = GpioFactory.getInstance();
            this.SR_CLK_OUTPUT_PIN = this.gpio.provisionDigitalOutputPin(SR_CLK_PIN);
            this.SR_NOE_OUTPUT_PIN = this.gpio.provisionDigitalOutputPin(SR_NOE_PIN);
            this.disableShiftRegisterOutput();
            this.SR_DAT_OUTPUT_PIN = this.gpio.provisionDigitalOutputPin(SR_DAT_PIN);
            this.SR_LAT_OUTPUT_PIN = this.gpio.provisionDigitalOutputPin(SR_LAT_PIN);
            this.closeAllStations();
            this.enableShiftRegisterOutput();
        }
    }

    @Override
    public void openAllStations() {
        for (int s = 0; s < this.numberOfStations; ++s) {
            this.stationState[s] = true;
        }
        this.updateStations();
    }

    @Override
    public void closeAllStations() {
        for (int s = 0; s < this.numberOfStations; ++s) {
            this.stationState[s] = false;
        }
        this.updateStations();
    }

    @Override
    public void openStation(int station) {
        this.checkStation(station);
        this.stationState[station] = true;
        this.updateStations();
    }

    @Override
    public void closeStation(int station) {
        this.checkStation(station);
        this.stationState[station] = false;
        this.updateStations();
    }

    @Override
    public boolean isStationOpen(int station) {
        this.checkStation(station);
        return this.stationState[station];
    }

    @Override
    public boolean isRainDetected() {
        throw new UnsupportedOperationException("Rain sensor access not supported in GPIO mode.");
    }

    @Override
    public void closeConnection() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }

    @Override
    public int getNumberOfStations() {
        return this.numberOfStations;
    }

    @Override
    public void setNumberOfStations(int numberOfStations) {
        if (this.numberOfStations == numberOfStations) {
            return;
        }
        this.numberOfStations = numberOfStations;
        this.stationState = Arrays.copyOf(this.stationState, numberOfStations);
    }

    private void updateStations() {
        if (USE_STUB || DEBUG_OUTPUT) {
            System.out.println("Station state updated to: ");
            for (int index = 0; index < this.numberOfStations; ++index) {
                boolean open = this.stationState[index];
                System.out.println("\tStation " + index + " open: " + open);
            }
            if (USE_STUB) {
                return;
            }
        }
        this.SR_CLK_OUTPUT_PIN.low();
        this.SR_LAT_OUTPUT_PIN.low();
        for (int s = 0; s < this.numberOfStations; ++s) {
            this.SR_CLK_OUTPUT_PIN.low();
            this.SR_DAT_OUTPUT_PIN.setState(this.stationState[this.numberOfStations - 1 - s]);
            this.SR_CLK_OUTPUT_PIN.high();
        }
        this.SR_LAT_OUTPUT_PIN.high();
    }

    private void disableShiftRegisterOutput() {
        if (USE_STUB) {
            return;
        }
        this.SR_NOE_OUTPUT_PIN.high();
    }

    private void enableShiftRegisterOutput() {
        if (USE_STUB) {
            return;
        }
        this.SR_NOE_OUTPUT_PIN.low();
    }

    private void checkStation(int station) {
        if (station < 0 || station >= this.numberOfStations) {
            throw new IllegalArgumentException("Station " + station + " is out of valid range [0 - " + this.numberOfStations + "]");
        }
    }
}

