/*
 * Decompiled with CFR 0.152.
 */
package net.jonathangiles.opensprinkler;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Map;
import net.jonathangiles.opensprinkler.JSON;
import net.jonathangiles.opensprinkler.OpenSprinkler;

class OpenSprinklerHTTP
implements OpenSprinkler {
    private static final String MD5_HASH_ALGORITHM = "MD5";
    private static final String UTF8_CHAR_SET = "UTF-8";
    private static final String DEFAULT_MD5_PASSWORD_HASH = "a6d82bced638de3def1e9bbb4983225c";
    private final String url;
    private final String password;
    private final String passwordMD5;
    private int firmwareVersion = -1;
    private int numberOfStations = 8;

    public OpenSprinklerHTTP(String url, String password) {
        this.url = url.endsWith("/") ? url : url + "/";
        this.password = password;
        this.passwordMD5 = this.getMD5Hash(password);
        this.firmwareVersion = this.getFirmwareVersion();
        if (this.firmwareVersion < 210) {
            this.send("cv?pw=" + password + "&" + (Object)((Object)Command.ENABLE_MANUAL_MODE));
        }
    }

    @Override
    public void openAllStations() {
        for (int s = 1; s <= this.numberOfStations; ++s) {
            this.openStation(s);
        }
    }

    @Override
    public void closeAllStations() {
        for (int s = 1; s <= this.numberOfStations; ++s) {
            this.closeStation(s);
        }
    }

    @Override
    public void openStation(int station) {
        if (this.firmwareVersion >= 210 && this.firmwareVersion <= 212) {
            this.send((Object)((Object)Command.STATION_COMMAND) + "?pw=" + this.password + "&sid=" + station + "&en=1" + "&t=64800");
        } else if (this.firmwareVersion >= 213) {
            this.send((Object)((Object)Command.STATION_COMMAND) + "?pw=" + this.passwordMD5 + "&sid=" + station + "&en=1" + "&t=64800");
        } else {
            this.send((Object)((Object)Command.OPEN_STATION) + "&t=0", station + 1 + "");
        }
    }

    @Override
    public void closeStation(int station) {
        if (this.firmwareVersion >= 210 && this.firmwareVersion <= 212) {
            this.send((Object)((Object)Command.STATION_COMMAND) + "?pw=" + this.password + "&sid=" + station + "&en=0");
        } else if (this.firmwareVersion >= 213) {
            this.send((Object)((Object)Command.STATION_COMMAND) + "?pw=" + this.passwordMD5 + "&sid=" + station + "&en=0");
        } else {
            this.send((Object)((Object)Command.CLOSE_STATION) + "&t=0", station + 1 + "");
        }
    }

    @Override
    public boolean isStationOpen(int station) {
        String response = null;
        ArrayList<?> stations = null;
        if (this.firmwareVersion >= 210 && this.firmwareVersion <= 212) {
            response = this.send((Object)((Object)Command.STATION_INFO) + "?pw=" + this.password);
            stations = this.jsonParseArrayList(response, JSONOption.STATIONS);
            return (Integer)stations.get(station) == 1;
        }
        if (this.firmwareVersion >= 213) {
            response = this.send((Object)((Object)Command.STATION_INFO) + "?pw=" + this.passwordMD5);
            stations = this.jsonParseArrayList(response, JSONOption.STATIONS);
            return (Integer)stations.get(station) == 1;
        }
        response = this.send(Command.IS_STATION_OPEN, station + 1 + "");
        return response != null && response.equals("1");
    }

    @Override
    public boolean isRainDetected() {
        String response = null;
        int option = -1;
        response = this.firmwareVersion >= 210 && this.firmwareVersion <= 212 ? this.send((Object)((Object)Command.STATUS_INFO) + "?pw=" + this.password) : (this.firmwareVersion >= 213 ? this.send((Object)((Object)Command.STATUS_INFO) + "?pw=" + this.passwordMD5) : this.send(Command.STATUS_INFO));
        option = this.jsonParseInt(response, JSONOption.RAIN_SENSOR);
        return option == 1;
    }

    @Override
    public void closeConnection() {
        if (this.firmwareVersion < 210) {
            this.send("cv?pw=" + this.password + "&" + (Object)((Object)Command.DISABLE_MANUAL_MODE));
        }
    }

    @Override
    public int getNumberOfStations() {
        return this.numberOfStations;
    }

    @Override
    public void setNumberOfStations(int numberOfStations) {
        this.numberOfStations = numberOfStations;
    }

    public int getFirmwareVersion() {
        try {
            String response = this.send(Command.OPTIONS_INFO);
            int version = this.jsonParseInt(response, JSONOption.FIRMWARE_VERSION);
            return version;
        }
        catch (Exception exp) {
            return -1;
        }
    }

    private String send(Command command) {
        return this.send(command.queryString);
    }

    private String send(Command command, String ... args) {
        return this.send(command.queryString, args);
    }

    private String send(String queryString) {
        return this.send(queryString, (String[])null);
    }

    private String send(String queryString, String ... args) {
        String _url = this.url;
        if (queryString.contains("$")) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb);
            formatter.format(queryString, args);
            formatter.close();
            _url = _url + sb.toString();
        } else {
            _url = _url + queryString;
        }
        try {
            String inputLine;
            URL obj = new URL(_url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getMD5Hash(String in) {
        try {
            byte[] bytesOfMessage = in.getBytes(UTF8_CHAR_SET);
            MessageDigest md5 = MessageDigest.getInstance(MD5_HASH_ALGORITHM);
            byte[] hash = md5.digest(bytesOfMessage);
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            String digest = sb.toString();
            return digest;
        }
        catch (Exception exp) {
            return DEFAULT_MD5_PASSWORD_HASH;
        }
    }

    private int jsonParseInt(String jsonData, JSONOption optionName) {
        return this.jsonParseInt(jsonData, optionName.optString);
    }

    private int jsonParseInt(String jsonData, String optionName) {
        Map jsonNvp = (Map)JSON.parse(jsonData);
        return (Integer)jsonNvp.get(optionName);
    }

    private String jsonParseString(String jsonData, JSONOption optionName) {
        return this.jsonParseString(jsonData, optionName.optString);
    }

    private String jsonParseString(String jsonData, String optionName) {
        Map jsonNvp = (Map)JSON.parse(jsonData);
        return (String)jsonNvp.get(optionName);
    }

    private ArrayList<?> jsonParseArrayList(String jsonData, JSONOption optionName) {
        return this.jsonParseArrayList(jsonData, optionName.optString);
    }

    private ArrayList<?> jsonParseArrayList(String jsonData, String optionName) {
        Map jsonNvp = (Map)JSON.parse(jsonData);
        return (ArrayList)jsonNvp.get(optionName);
    }

    public static enum JSONOption {
        FIRMWARE_VERSION("fwv"),
        RAIN_SENSOR("rs"),
        STATIONS("sn");

        private final String optString;

        private JSONOption(String optString) {
            this.optString = optString;
        }

        public String toString() {
            return this.optString;
        }
    }

    public static enum Command {
        ENABLE_MANUAL_MODE("mm=1"),
        DISABLE_MANUAL_MODE("mm=0"),
        OPEN_STATION("sn%1$s=1"),
        CLOSE_STATION("sn%1$s=0"),
        IS_STATION_OPEN("sn%1$s"),
        STATUS_INFO("jc"),
        OPTIONS_INFO("jo"),
        STATION_INFO("js"),
        STATION_COMMAND("cm");

        private final String queryString;

        private Command(String queryString) {
            this.queryString = queryString;
        }

        public String toString() {
            return this.queryString;
        }
    }
}

