/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.hwabstraction.opensprinkler.util;

import java.util.List;
import org.apache.log4j.Logger;

public final class OpenSprinklerUtil {
    private static final Logger log = Logger.getLogger(OpenSprinklerUtil.class);

    private OpenSprinklerUtil() {
    }

    public static String dataLog(byte data) {
        return OpenSprinklerUtil.dataLog(new byte[]{data});
    }

    public static String dataLog(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.append(String.format("%02x ", data[i]).toUpperCase());
        }
        return sb.toString();
    }

    public static String toHex(byte data) {
        return String.format("%02x", data).toUpperCase();
    }

    public static String toHex(long data) {
        return String.format("%02x", data).toUpperCase();
    }

    public static byte[] toByteFromHex(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String hardwareIdsToString(List<Long> hardwareIds) {
        StringBuffer strbuf = new StringBuffer();
        int index = 1;
        for (Long hardwareId : hardwareIds) {
            strbuf.append(OpenSprinklerUtil.hardwareIdToString(hardwareId, index));
            if (index < hardwareIds.size()) {
                strbuf.append("; ");
            }
            ++index;
        }
        return strbuf.toString();
    }

    public static String hardwareIdToString(Long hardwareId) {
        return OpenSprinklerUtil.hardwareIdToString(hardwareId, null);
    }

    public static String hardwareIdToString(Long hardwareId, Integer index) {
        if (index != null) {
            return "HardwareId " + index + ": " + hardwareId + " (" + OpenSprinklerUtil.toHex(hardwareId) + ")";
        }
        return "HardwareId: " + hardwareId + " (" + OpenSprinklerUtil.toHex(hardwareId) + ")";
    }
}

