/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.hwabstraction.opensprinkler.test;

import at.creadoo.homer.hwabstraction.opensprinkler.OpenSprinklerHardware;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.log4j.Logger;

public class Test {
    private static final Logger log = Logger.getLogger(Test.class);
    private static OpenSprinklerHardware openSprinklerHardware;

    public static void main(String[] args) {
        Test.printUsage();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            Test.printLineHeader();
            String line = in.readLine().trim();
            while (line != null) {
                if (line.isEmpty()) {
                    Test.printLineHeader();
                } else {
                    try {
                        if (line.equalsIgnoreCase(Command.HELP.getValue())) {
                            Test.printUsage();
                        } else {
                            if (line.equalsIgnoreCase(Command.EXIT.getValue())) {
                                Test.disconnect();
                                break;
                            }
                            if (line.equalsIgnoreCase(Command.CONNECT.getValue())) {
                                Test.connect();
                            } else if (line.equalsIgnoreCase(Command.DISCONNECT.getValue())) {
                                Test.disconnect();
                            } else if (line.equalsIgnoreCase(Command.STATUS.getValue())) {
                                Test.status();
                            } else if (line.equalsIgnoreCase(Command.TEST.getValue())) {
                                Test.test();
                            } else {
                                System.out.println("Command not found: '" + line + "'");
                            }
                        }
                    }
                    catch (Throwable ex) {
                        System.out.println("[ERROR] " + ex.getMessage());
                        ex.printStackTrace(System.out);
                    }
                    Test.printLineHeader();
                }
                line = in.readLine().trim();
            }
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void connect() {
        openSprinklerHardware = new OpenSprinklerHardware();
        openSprinklerHardware.setUrl("http://192.168.0.2/");
        openSprinklerHardware.setPassword("opendoor");
        openSprinklerHardware.init();
    }

    private static void disconnect() {
        if (openSprinklerHardware != null) {
            openSprinklerHardware.destroy();
        }
        openSprinklerHardware = null;
    }

    private static void status() {
        if (openSprinklerHardware != null) {
            Map<Integer, Boolean> status = openSprinklerHardware.getStationStatus();
            for (Integer stationId : status.keySet()) {
                log.info((Object)("Status for Station " + stationId + " is '" + (status.get(stationId) != false ? "opened" : "closed") + "'"));
            }
        } else {
            log.info((Object)"Device not connected!");
        }
    }

    private static void test() {
        if (openSprinklerHardware != null) {
            openSprinklerHardware.openStation(1);
        } else {
            log.info((Object)"Device not connected!");
        }
    }

    private static void printUsage() {
        System.out.println("Available commands:");
        for (Command command : Command.values()) {
            System.out.println("   " + command.getValue());
        }
        System.out.println("");
    }

    private static void printLineHeader() {
        System.out.print("> ");
    }

    private static enum Command {
        HELP("help"),
        EXIT("exit"),
        CONNECT("connect"),
        DISCONNECT("disconnect"),
        STATUS("status"),
        TEST("test");

        private String value;

        private Command(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

