/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.hwabstraction.opensprinkler;

import at.ac.ait.hbs.homer.core.common.device.DeviceValue;
import at.ac.ait.hbs.homer.core.common.enumerations.BatteryStatus;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceMessageType;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceProtocol;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceType;
import at.ac.ait.hbs.homer.core.common.event.EventBuilder;
import at.ac.ait.hbs.homer.core.common.event.EventProperties;
import at.ac.ait.hbs.homer.core.common.event.EventTopic;
import at.ac.ait.hbs.homer.core.common.event.util.EventUtil;
import at.ac.ait.hbs.homer.core.common.exception.DeviceMessageTypeNotUniqueException;
import at.ac.ait.hbs.homer.core.common.model.DBMessage;
import at.ac.ait.hbs.homer.core.common.scenario.helper.Device;
import at.ac.ait.hbs.homer.core.common.util.PropertyUtil;
import java.util.HashMap;
import java.util.Map;
import net.jonathangiles.opensprinkler.OpenSprinkler;
import net.jonathangiles.opensprinkler.OpenSprinklerFactory;
import org.apache.log4j.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class OpenSprinklerHardware
implements EventHandler,
OpenSprinkler {
    private static final Logger log = Logger.getLogger(OpenSprinklerHardware.class);
    private static final int HARDWARE_ID = 1234567890;
    private OpenSprinkler openSprinkler;
    private String url;
    private String password;
    private int numberOfStations = 8;
    private EventAdmin eventAdmin;

    public OpenSprinklerHardware() {
        log.info((Object)("Initializing " + this.getClass().getSimpleName()));
    }

    public void init() {
        log.info((Object)("Starting " + this.getClass().getSimpleName()));
        this.openSprinkler = OpenSprinklerFactory.newHttpConnection(this.url, this.password);
        if (this.openSprinkler == null) {
            log.error((Object)"Error while initializing connection to OpenSprinkler");
            return;
        }
        this.openSprinkler.setNumberOfStations(this.numberOfStations);
        log.info((Object)("Connected to OpenSprinkler device (" + this.url + ")"));
        for (int stationId = 1; stationId <= this.openSprinkler.getNumberOfStations(); ++stationId) {
            log.info((Object)("Status for Station " + stationId + " is '" + (this.openSprinkler.isStationOpen(stationId - 1) ? "opened" : "closed") + "'"));
        }
    }

    public void destroy() {
        log.info((Object)("Stopping " + this.getClass().getSimpleName()));
        if (this.openSprinkler != null) {
            this.openSprinkler.closeConnection();
        }
        this.openSprinkler = null;
    }

    public void handleEvent(Event event) {
        log.debug((Object)("Received " + event));
        try {
            if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_ACTUATOR_REQUEST).booleanValue()) {
                Device device = (Device)event.getProperty(EventProperties.DEVICE.name());
                DeviceValue deviceValue = (DeviceValue)event.getProperty(EventProperties.DEVICE_VALUE.name());
                log.debug((Object)("Actuator request: " + device));
                if (!DeviceProtocol.UNSPECIFIED.equals((Object)device.getProtocol())) {
                    log.debug((Object)("Device protocol '" + device.getProtocol() + "' not supported!"));
                    return;
                }
                if (device.getHardwareId() == null) {
                    log.debug((Object)("Actuator with id " + device.getDeviceId() + " has no hardware id!"));
                    return;
                }
                if (!DeviceType.MDC_AI_TYPE_ACTUATOR_SWITCH.equals((Object)device.getType())) {
                    log.debug((Object)("Device type '" + device.getType().name() + "' not supported!"));
                    return;
                }
                Boolean on = DeviceMessageType.MDC_AI_FLAG_SENSOR_SWITCH_ON.getValue().equals((Object)((Integer)deviceValue.getValue()));
                if (device.getHardwareId().equals(1234567890)) {
                    if (device.getHardwareId2() != null && this.isValidStation(device.getHardwareId2().intValue())) {
                        if (on.booleanValue()) {
                            log.debug((Object)("Set station " + device.getHardwareId2().intValue() + " to opened"));
                            this.openSprinkler.openStation(device.getHardwareId2().intValue() - 1);
                        } else {
                            log.debug((Object)("Set station " + device.getHardwareId2().intValue() + " to closed"));
                            this.openSprinkler.closeStation(device.getHardwareId2().intValue() - 1);
                        }
                    } else if (on.booleanValue()) {
                        log.debug((Object)"Set all stations to opened");
                        this.openSprinkler.openAllStations();
                    } else {
                        log.debug((Object)"Set all stations to opened");
                        this.openSprinkler.closeAllStations();
                    }
                    this.sendActuatorMessage(device, deviceValue);
                }
            }
        }
        catch (Throwable ex) {
            log.error((Object)"Error while processing incoming event", ex);
        }
    }

    private void sendActuatorMessage(Device device, DeviceValue deviceValue) {
        this.sendActuatorMessage(device, deviceValue, null, null);
    }

    private void sendActuatorMessage(Device device, DeviceValue deviceValue, Double data1, Double data2) {
        log.debug((Object)"Sending actuator message");
        DBMessage message = new DBMessage();
        message.setDeviceId(device.getDeviceId());
        try {
            message.setMessageType(DeviceMessageType.getFlag((DeviceType)device.getType(), (DeviceValue)deviceValue));
        }
        catch (DeviceMessageTypeNotUniqueException ex) {
            log.error((Object)"Error setting DeviceMessageType", (Throwable)ex);
        }
        message.setTimestamp(System.currentTimeMillis());
        message.setBatteryStatus(BatteryStatus.NO_CONDITION_DETECTED);
        if (data1 != null) {
            message.setData1(data1.doubleValue());
        }
        if (data2 != null) {
            message.setData2(data2.doubleValue());
        }
        Event event = EventBuilder.createActuatorMessageEvent((DBMessage)message, (DeviceValue)deviceValue);
        this.eventAdmin.postEvent(event);
    }

    public Map<Integer, Boolean> getStationStatus() {
        HashMap<Integer, Boolean> result = new HashMap<Integer, Boolean>();
        for (int stationId = 1; stationId <= this.openSprinkler.getNumberOfStations(); ++stationId) {
            result.put(stationId, this.openSprinkler.isStationOpen(stationId - 1));
        }
        return result;
    }

    private boolean isValidStation(int stationId) {
        return stationId > 0 && stationId <= this.openSprinkler.getNumberOfStations();
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public final void setUrl(String url) {
        this.url = PropertyUtil.sanitizeValue((String)url);
    }

    public final void setPassword(String password) {
        this.password = PropertyUtil.sanitizeValue((String)password);
    }

    public void setStations(int numberOfStations) {
        if (numberOfStations > 0 && numberOfStations <= 56) {
            this.numberOfStations = numberOfStations;
            if (this.openSprinkler != null) {
                this.openSprinkler.setNumberOfStations(numberOfStations);
            }
        }
    }

    @Override
    public void openAllStations() {
        if (this.openSprinkler != null) {
            this.openSprinkler.openAllStations();
        }
    }

    @Override
    public void closeAllStations() {
        if (this.openSprinkler != null) {
            this.openSprinkler.closeAllStations();
        }
    }

    @Override
    public void openStation(int stationId) {
        if (this.openSprinkler != null && this.isValidStation(stationId)) {
            this.openSprinkler.openStation(stationId - 1);
        }
    }

    @Override
    public void closeStation(int stationId) {
        if (this.openSprinkler != null && this.isValidStation(stationId)) {
            this.openSprinkler.closeStation(stationId - 1);
        }
    }

    @Override
    public boolean isStationOpen(int stationId) {
        if (this.openSprinkler != null && this.isValidStation(stationId)) {
            return this.openSprinkler.isStationOpen(stationId - 1);
        }
        return false;
    }

    @Override
    public boolean isRainDetected() {
        if (this.openSprinkler != null) {
            return this.openSprinkler.isRainDetected();
        }
        return false;
    }

    @Override
    public void closeConnection() {
    }

    @Override
    public int getNumberOfStations() {
        if (this.openSprinkler != null) {
            return this.openSprinkler.getNumberOfStations();
        }
        return 0;
    }

    @Override
    public void setNumberOfStations(int numberOfStations) {
        this.setStations(numberOfStations);
    }
}

