/*
 * Copyright 2016 crea-doo.at
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package at.creadoo.homer.hwabstraction.netio.util;

import java.util.List;

import org.apache.log4j.Logger;

/**
 * Provides small utils for the hardware bundle.
 */
public final class NetIOUtil {

    private static final Logger log = Logger.getLogger(NetIOUtil.class);

	private NetIOUtil() {
		//
	}
	
	public static String dataLog(byte data) {
		return dataLog(new byte[] { data });
	}
	
	public static String dataLog(byte[] data) {
		final StringBuilder sb = new StringBuilder();
		for (int i = 0; i < data.length; i++) {
			sb.append(String.format("%02x ", Byte.valueOf(data[i])).toUpperCase());
		}
		return sb.toString();
	}
    
	public static String toHex(final byte data) {
		return String.format("%02x", Byte.valueOf(data)).toUpperCase();
	}

	public static String toHex(final long data) {
		return String.format("%02x", Long.valueOf(data)).toUpperCase();
	}
    
	public static byte[] toByteFromHex(final String s) {
		int len = s.length();
		byte[] data = new byte[len / 2];
		for (int i = 0; i < len; i += 2) {
			data[i / 2] = (byte) ((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
		}
		return data;
	}
	
    public static String hardwareIdsToString(final List<Long> hardwareIds) {
		final StringBuffer strbuf = new StringBuffer();
		int index = 1;
		for (final Long hardwareId: hardwareIds) {
			strbuf.append(hardwareIdToString(hardwareId, index));
			if (index < hardwareIds.size()) {
				strbuf.append("; ");
			} else {
				
			}
			index++;
		}
		return strbuf.toString();
	}
	
    public static String hardwareIdToString(final Long hardwareId) {
		return hardwareIdToString(hardwareId, null);
	}
	
    public static String hardwareIdToString(final Long hardwareId, final Integer index) {
		if (index != null) {
			return "HardwareId " + index +": " + hardwareId +" (" + toHex(hardwareId) + ")";
		} else {
			return "HardwareId: " + hardwareId +" (" + toHex(hardwareId) + ")";
		}
	}
}
