/*
 * Copyright 2016 crea-doo.at
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License. 
 */
package at.creadoo.homer.hwabstraction.netio.test;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

import org.apache.log4j.Logger;

import at.creadoo.homer.hwabstraction.netio.NetIOHardware;
import at.creadoo.homer.hwabstraction.netio.util.NetIOUtil;

public class Test {

    private static final Logger log = Logger.getLogger(Test.class);

	private static NetIOHardware netIOHardware;
	
	/**
	 * @param args
	 */
	public static void main(final String[] args) {
		printUsage();

		try {
			BufferedReader in = new BufferedReader(new InputStreamReader(System.in));

			printLineHeader();

			for (String line = in.readLine().trim(); line != null; line = in.readLine().trim()) {

				if (line.isEmpty()) {
					printLineHeader();
					continue;
				}

				try {
					if (line.equalsIgnoreCase(Command.HELP.getValue())) {
						printUsage();
					} else if (line.equalsIgnoreCase(Command.EXIT.getValue())) {
						disconnect();
						break;
					} else if (line.equalsIgnoreCase(Command.CONNECT.getValue())) {
						connect();
					} else if (line.equalsIgnoreCase(Command.DISCONNECT.getValue())) {
						disconnect();
					} else {
						System.out.println("Command not found: '" + line + "'");
					}
				} catch (Throwable ex) {
					System.out.println("[ERROR] " + ex.getMessage());
					ex.printStackTrace(System.out);
				}

				printLineHeader();
			}

			in.close();

		} catch (Exception ex) {
			//
		}
	}

	/**
	 * Prepare everything
	 */
	private static void connect() {
		netIOHardware = new NetIOHardware();
		
		netIOHardware.setIpHost("192.168.0.99");
		netIOHardware.setIpPort("1234");
		netIOHardware.setUsername("admin");
		netIOHardware.setPassword("admin");

		netIOHardware.init();
	}
	
	private static void disconnect() {
		if (netIOHardware != null) {
			netIOHardware.destroy();
		}
		netIOHardware = null;
	}
	
	private static void printInfo(final String s) {
		byte[] bytes = NetIOUtil.toByteFromHex(s);
		
		System.out.println(s + " --> " + NetIOUtil.dataLog(bytes) + " --> " + NetIOUtil.dataLog(s.getBytes(Charset.forName("UTF-8"))));
		System.out.println();
	}
    
    /**
     * Print usage function
     */
    private static void printUsage() {
    	System.out.println("Available commands:");
    	
    	for (Command command : Command.values()) {
        	System.out.println("   " + command.getValue());
    	}
    	
    	System.out.println("");
    }
    
    /**
     * Print line header function
     */
    private static void printLineHeader() {
    	System.out.print("> ");
    }
    
    private enum Command {

    	HELP("help"),
    	EXIT("exit"),
    	CONNECT("connect"),
    	DISCONNECT("disconnect");
    	
    	private String value;

    	private Command(final String value) {
    		this.value = value;
    	}

    	public String getValue() {
    		return this.value;
    	}
    }

}
