/*
 * Decompiled with CFR 0.152.
 */
package at.creadoo.homer.decanter.collector;

import at.ac.ait.hbs.homer.core.common.DataAccess;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationService;
import at.ac.ait.hbs.homer.core.common.configuration.ConfigurationValueKey;
import at.ac.ait.hbs.homer.core.common.device.DeviceValue;
import at.ac.ait.hbs.homer.core.common.enumerations.DeviceMessageType;
import at.ac.ait.hbs.homer.core.common.event.EventProperties;
import at.ac.ait.hbs.homer.core.common.event.EventTopic;
import at.ac.ait.hbs.homer.core.common.event.util.EventTopicMatcher;
import at.ac.ait.hbs.homer.core.common.event.util.EventUtil;
import at.ac.ait.hbs.homer.core.common.model.DBDevice;
import at.ac.ait.hbs.homer.core.common.model.DBFlat;
import at.ac.ait.hbs.homer.core.common.model.DBMessage;
import at.ac.ait.hbs.homer.core.common.model.DBRoom;
import at.ac.ait.hbs.homer.core.common.scenario.SystemState;
import at.ac.ait.hbs.homer.core.common.systemstate.SystemStateBlackboard;
import at.ac.ait.hbs.homer.core.common.systemstate.SystemStateListener;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public final class Collector
implements EventHandler,
SystemStateListener {
    private static final Logger log = Logger.getLogger(Collector.class);
    private static final List<String> excludeTopics = new ArrayList<String>();
    private static final String COLLECTOR_FILTER_ALL = "*";
    private static final String DECANTER_TOPIC_PREFIX = "decanter/";
    private static final String COLLECTOR_DECANTER_TOPIC_PREFIX = "decanter/collect/homer/";
    private ConfigurationService configurationService;
    private DataAccess dataAccess;
    private EventAdmin eventAdmin;
    private SystemStateBlackboard systemStateBlackboard;
    private List<String> topics = new ArrayList<String>();
    private final Map<Integer, DBDevice> deviceCache = new HashMap<Integer, DBDevice>();
    private final Map<Integer, DBRoom> roomCache = new HashMap<Integer, DBRoom>();
    private final Map<Integer, DBFlat> flatCache = new HashMap<Integer, DBFlat>();
    private String homerSystemID = "";

    public void init() {
        log.info((Object)("Starting " + this.getClass().getSimpleName()));
        try {
            this.homerSystemID = this.configurationService.getMetaValue(ConfigurationValueKey.SYSTEM_ID).getStringValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.systemStateBlackboard.addListener((SystemStateListener)this);
        this.updateCache();
    }

    public void destroy() {
        log.info((Object)("Stopping " + this.getClass().getSimpleName()));
        this.systemStateBlackboard.removeListener((SystemStateListener)this);
    }

    public final void setBlackBoard(SystemStateBlackboard blackBoard) {
        this.systemStateBlackboard = blackBoard;
    }

    public final void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public final void setDataAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
    }

    public final void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public final void setTopics(String topics) {
        this.topics = Arrays.asList(topics.split(","));
    }

    public void handleEvent(Event event) {
        HashMap<String, Object> hashMap;
        String topic;
        block18: {
            if (event == null) {
                return;
            }
            topic = event.getTopic();
            if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICES_CONFIGURATION_CHANGE_MESSAGE)) {
                log.debug((Object)"Reloading device cache");
                this.updateCache();
            }
            for (String string : excludeTopics) {
                if (!topic.startsWith(string)) continue;
                return;
            }
            boolean resume = false;
            for (String item : this.topics) {
                if (COLLECTOR_FILTER_ALL.equals(item.trim())) {
                    resume = true;
                    break;
                }
                if (!EventTopicMatcher.isMatch((String)topic, (String)item.trim())) continue;
                resume = true;
                break;
            }
            if (!resume) {
                return;
            }
            hashMap = new HashMap<String, Object>();
            this.enrichGeneral(hashMap);
            if (EventUtil.isEventComplete((Event)event)) {
                hashMap.put("topic", topic);
                hashMap.put("event.topics", topic);
                try {
                    DBDevice device;
                    if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICE_MESSAGE) || EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICE_STATUS_MESSAGE)) {
                        DBMessage message = (DBMessage)event.getProperty(EventProperties.MESSAGE.name());
                        DeviceValue deviceValue = (DeviceValue)event.getProperty(EventProperties.DEVICE_VALUE.name());
                        this.enrichDeviceValue(hashMap, deviceValue);
                        hashMap.put("messageID", message.getDeviceId());
                        hashMap.put("messageType", message.getMessageType().name());
                        hashMap.put("messageTypeTitle", message.getMessageType().getTitle());
                        hashMap.put("messageTypeID", message.getMessageType().getId());
                        hashMap.put("batteryStatus", message.getBatteryStatus().name());
                        hashMap.put("batteryStatusID", message.getBatteryStatus().getValue());
                        hashMap.put("messageTimestamp", message.getTimestamp().getMillis());
                        hashMap.put("messageTimestampReadable", message.getTimestamp().toString());
                        if (this.deviceCache.containsKey(message.getDeviceId())) {
                            DBDevice device2 = this.deviceCache.get(message.getDeviceId());
                            this.enrichDevice(hashMap, device2);
                        }
                        if (event.containsProperty(EventProperties.TAG.name())) {
                            hashMap.put("tag", event.getProperty(EventProperties.TAG.name()));
                        }
                        break block18;
                    }
                    if (EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICE_REQUEST)) {
                        device = (DBDevice)event.getProperty(EventProperties.DEVICE.name());
                        DeviceMessageType deviceMessageType = (DeviceMessageType)event.getProperty(EventProperties.DEVICE_MESSAGE_TYPE.name());
                        DeviceValue deviceValue = (DeviceValue)event.getProperty(EventProperties.DEVICE_VALUE.name());
                        this.enrichDevice(hashMap, device);
                        this.enrichDeviceValue(hashMap, deviceValue);
                        hashMap.put("deviceMessageType", deviceMessageType.name());
                        hashMap.put("deviceMessageTypeTitle", deviceMessageType.getTitle());
                        hashMap.put("deviceMessageTypeID", deviceMessageType.getId());
                        break block18;
                    }
                    if (!EventUtil.isEventOfType((Event)event, (EventTopic)EventTopic.HOMECONTROL_DEVICE_STATUS_REQUEST)) break block18;
                    device = (DBDevice)event.getProperty(EventProperties.DEVICE.name());
                    this.enrichDevice(hashMap, device);
                    if (event.containsProperty(EventProperties.TAG.name())) {
                        hashMap.put("tag", event.getProperty(EventProperties.TAG.name()));
                    }
                }
                catch (Throwable ex) {
                    log.error((Object)"Error while processing incoming event", ex);
                }
            } else {
                for (String property : event.getPropertyNames()) {
                    if (property.equals("type")) {
                        if (event.getProperty(property) != null) {
                            hashMap.put("eventType", event.getProperty(property).toString());
                            continue;
                        }
                        hashMap.put("eventType", "eventadmin");
                        continue;
                    }
                    hashMap.put(property, event.getProperty(property));
                }
            }
        }
        this.eventAdmin.sendEvent(new Event(COLLECTOR_DECANTER_TOPIC_PREFIX + topic, hashMap));
    }

    public void handleSystemStateSet(SystemState state, SystemState stateOld) {
        if (state != null) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            this.enrichGeneral(properties);
            properties.put("topic", EventTopic.SYSTEM_MESSAGE.getValue());
            properties.put("event.topics", EventTopic.SYSTEM_MESSAGE.getValue());
            properties.put("stateID", state.getId());
            properties.put("stateName", state.getName());
            properties.put("stateDisplayable", state.getDisplayable());
            properties.put("statePublishable", state.getPublishable());
            properties.put("stateType", state.getType().name());
            properties.put("stateTypeTitle", state.getType().getTitle());
            properties.put("stateValue", state.getValue());
            properties.put("stateDefaultValue", state.getDefaultValue());
            if (stateOld != null) {
                properties.put("stateOldValue", stateOld.getValue());
            }
            this.eventAdmin.sendEvent(new Event(COLLECTOR_DECANTER_TOPIC_PREFIX + EventTopic.SYSTEM_MESSAGE.getValue(), properties));
        }
    }

    public void handleSystemStateRemove(SystemState state) {
    }

    private void updateCache() {
        this.deviceCache.clear();
        this.roomCache.clear();
        this.flatCache.clear();
        if (this.dataAccess == null) {
            return;
        }
        this.deviceCache.putAll(this.dataAccess.getDevicesAsMap());
        log.debug((Object)("Devices in cache: " + this.deviceCache.size()));
        this.roomCache.putAll(this.dataAccess.getRoomsAsMap());
        log.debug((Object)("Rooms in cache: " + this.roomCache.size()));
        this.flatCache.putAll(this.dataAccess.getFlatsAsMap());
        log.debug((Object)("Flats in cache: " + this.flatCache.size()));
    }

    private void enrichGeneral(Map<String, Object> properties) {
        properties.put("type", "homer");
        properties.put("systemID", this.homerSystemID);
        String karafName = System.getProperty("karaf.name");
        if (karafName != null) {
            properties.put("karafName", karafName);
        }
        try {
            properties.put("hostAddress", InetAddress.getLocalHost().getHostAddress());
            properties.put("hostName", InetAddress.getLocalHost().getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void enrichDevice(Map<String, Object> properties, DBDevice device) {
        if (device == null) {
            return;
        }
        properties.put("deviceID", device.getId());
        properties.put("deviceType", device.getType().name());
        properties.put("deviceTypeTitle", device.getType().getTitle());
        properties.put("deviceTypeID", device.getType().getValue());
        properties.put("deviceCategoryType", device.getCategoryType().name());
        properties.put("deviceCategoryTypeID", device.getCategoryType().getValue());
        properties.put("deviceProtocol", device.getProtocol().name());
        properties.put("deviceProtocolTitle", device.getProtocol().getTitle());
        properties.put("deviceProtocolID", device.getProtocol().getValue());
        if (device.getLocX() != null) {
            properties.put("deviceLocationX", device.getLocX());
        } else {
            properties.put("deviceLocationX", 0.0);
        }
        if (device.getLocY() != null) {
            properties.put("deviceLocationY", device.getLocY());
        } else {
            properties.put("deviceLocationY", 0.0);
        }
        if (device.getLocZ() != null) {
            properties.put("deviceLocationZ", device.getLocZ());
        } else {
            properties.put("deviceLocationZ", 0.0);
        }
        if (this.roomCache.containsKey(device.getRoomId())) {
            DBRoom room = this.roomCache.get(device.getRoomId());
            this.enrichRoom(properties, room);
        }
        if (this.flatCache.containsKey(device.getFlatId())) {
            DBFlat flat = this.flatCache.get(device.getFlatId());
            this.enrichFlat(properties, flat);
        }
        for (String key : device.getMetaValues().keySet()) {
            try {
                properties.put(key, device.getMetaValue(key).getValue().toString());
            }
            catch (Throwable throwable) {}
        }
    }

    private void enrichDeviceValue(Map<String, Object> properties, DeviceValue deviceValue) {
        if (deviceValue == null) {
            return;
        }
        properties.put("deviceValue", deviceValue.getValue().toString());
        properties.put("deviceValueType", deviceValue.getType().name());
    }

    private void enrichRoom(Map<String, Object> properties, DBRoom room) {
        if (room == null) {
            return;
        }
        properties.put("roomID", room.getId());
        properties.put("roomType", room.getType().name());
        properties.put("roomTypeTitle", room.getType().getTitle());
        properties.put("roomTypeID", room.getType().getValue());
        if (room.getHeight() != null) {
            properties.put("roomHeight", room.getHeight());
        } else {
            properties.put("roomHeight", 0.0);
        }
        for (String key : room.getMetaValues().keySet()) {
            try {
                properties.put(key, room.getMetaValue(key).getValue().toString());
            }
            catch (Throwable throwable) {}
        }
    }

    private void enrichFlat(Map<String, Object> properties, DBFlat flat) {
        if (flat == null) {
            return;
        }
        properties.put("flatID", flat.getId());
        properties.put("flatAddress", flat.getAddress());
        properties.put("flatDescription", flat.getDescription());
        for (String key : flat.getMetaValues().keySet()) {
            try {
                properties.put(key, flat.getMetaValue(key).getValue().toString());
            }
            catch (Throwable throwable) {}
        }
    }

    static {
        excludeTopics.add("org/osgi/service/");
        excludeTopics.add("org/osgi/framework/");
        excludeTopics.add("org/apache/karaf/");
        excludeTopics.add(DECANTER_TOPIC_PREFIX);
    }
}

