/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.iryna.implementation;

import at.chrl.iryna.ConnectionState;
import at.chrl.iryna.IrynaConfig;
import at.chrl.iryna.implementation.IrynaPacketHandler;
import at.chrl.iryna.implementation.IrynaPacketIncoming;
import at.chrl.iryna.implementation.IrynaPacketOutgoing;
import at.chrl.nutils.network.AConnection;
import at.chrl.nutils.network.Dispatcher;
import at.chrl.nutils.network.PacketProcessor;
import at.chrl.nutils.network.packet.BaseClientPacket;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.PriorityBlockingQueue;

public class IrynaConnection
extends AConnection {
    private ConnectionState state = ConnectionState.DISCONNECTED;
    private final PriorityBlockingQueue<IrynaPacketOutgoing> messagesToSend = new PriorityBlockingQueue();
    private static final PacketProcessor<IrynaConnection> processor = new PacketProcessor(IrynaConfig.PACKET_PROCESSOR_MIN_THREADS, IrynaConfig.PACKET_PROCESSOR_MAX_THREADS);

    public IrynaConnection(SocketChannel sc, Dispatcher d) throws IOException {
        super(sc, d);
        this.state = ConnectionState.CONNECTED;
        IrynaConfig.Iryna.out.println("[Iryna] Connection from: " + this.getIP());
    }

    protected boolean processData(ByteBuffer data) {
        IrynaPacketIncoming packet = IrynaPacketHandler.handle(data, this);
        IrynaConfig.Iryna.PACKET_LOG.println("[Iryna] " + this.getIP() + " - Received Packet: " + packet.toString());
        if (packet.read()) {
            processor.executePacket((BaseClientPacket)packet);
        }
        return true;
    }

    protected boolean writeData(ByteBuffer data) {
        IrynaPacketOutgoing packet = this.messagesToSend.poll();
        if (packet == null) {
            return false;
        }
        packet.write(this, data);
        return true;
    }

    protected long getDisconnectionDelay() {
        return 0L;
    }

    protected void onDisconnect() {
        IrynaConfig.Iryna.out.println("[Iryna] Disconnected: " + this.getIP());
    }

    protected void onServerClose() {
        this.close(true);
    }

    public String toString() {
        return "[Iryna] " + this.getIP();
    }

    public final ConnectionState getState() {
        return this.state;
    }

    public final void sendPacket(IrynaPacketOutgoing msg) {
        if (this.isWriteDisabled()) {
            return;
        }
        IrynaConfig.Iryna.PACKET_LOG.println(String.format("[Iryna] sending packet: %s", new Object[]{msg}));
        this.messagesToSend.add(msg);
        this.enableWriteInterest();
    }

    public void close(boolean forced) {
        this.close(null, forced);
    }

    public void close(IrynaPacketOutgoing closePacket, boolean forced) {
        if (this.isWriteDisabled()) {
            return;
        }
        IrynaConfig.Iryna.PACKET_LOG.println("[Iryna] sending packet: " + (Object)((Object)closePacket) + " and closing connection after that.");
        this.pendingClose = true;
        this.isForcedClosing = forced;
        this.messagesToSend.clear();
        this.messagesToSend.add(closePacket);
        this.enableWriteInterest();
    }
}

