/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.iryna;

import at.chrl.iryna.IrynaConfig;
import at.chrl.iryna.implementation.IrynaConnectionFactoryImpl;
import at.chrl.nutils.JVMInfoUtil;
import at.chrl.nutils.network.ConnectionFactory;
import at.chrl.nutils.network.NioServer;
import at.chrl.nutils.network.ServerCfg;

public final class IrynaServer {
    private IrynaServer() {
    }

    public static final IrynaServer getInstace() {
        return SingletonHolder.instance;
    }

    public NioServer getNioServerInstance() {
        return SingletonHolder.nioInstance;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        sb.append(JVMInfoUtil.printSection((String)"IRYNA Server"));
        sb.append(System.lineSeparator());
        sb.append(JVMInfoUtil.printSection((String)super.toString()));
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static void main(String[] args) {
        IrynaConfig.Iryna.out.print(IrynaServer.getInstace());
    }

    private static final class SingletonHolder {
        private static final IrynaServer instance;
        private static final NioServer nioInstance;

        private SingletonHolder() {
        }

        static {
            ServerCfg config = new ServerCfg(IrynaConfig.BIND_ADDRESS, IrynaConfig.PORT, IrynaConfig.CONNECTION_NAME, (ConnectionFactory)new IrynaConnectionFactoryImpl());
            nioInstance = new NioServer(IrynaConfig.DISPATCHER_THREAD_COUNT, new ServerCfg[]{config});
            instance = new IrynaServer();
        }
    }
}

