/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.database;

import at.chrl.database.DatabaseConfig;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseFactory {
    private static final Logger log = LoggerFactory.getLogger(DatabaseFactory.class);
    private static BoneCP connectionPool;
    private static String databaseName;
    private static int databaseMajorVersion;
    private static int databaseMinorVersion;

    public static synchronized void init() {
        if (connectionPool != null) {
            return;
        }
        try {
            DatabaseConfig.DATABASE_DRIVER.newInstance();
        }
        catch (Exception e) {
            log.error("Error obtaining DB driver", (Throwable)e);
            throw new Error("DB Driver doesnt exist!");
        }
        if (DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MIN > DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MAX) {
            log.error("Please check your database configuration. Minimum amount of connections is > maximum");
            DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MAX = DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MIN;
        }
        BoneCPConfig config = new BoneCPConfig();
        config.setPartitionCount(DatabaseConfig.DATABASE_BONECP_PARTITION_COUNT);
        config.setMinConnectionsPerPartition(DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MIN);
        config.setMaxConnectionsPerPartition(DatabaseConfig.DATABASE_BONECP_PARTITION_CONNECTIONS_MAX);
        config.setUsername(DatabaseConfig.DATABASE_USER);
        config.setPassword(DatabaseConfig.DATABASE_PASSWORD);
        config.setJdbcUrl(DatabaseConfig.DATABASE_URL);
        config.setDisableJMX(true);
        try {
            connectionPool = new BoneCP(config);
        }
        catch (SQLException e) {
            log.error("Error while creating DB Connection pool", (Throwable)e);
            throw new Error("DatabaseFactory not initialized!", e);
        }
        try {
            Connection c = DatabaseFactory.getConnection();
            DatabaseMetaData dmd = c.getMetaData();
            databaseName = dmd.getDatabaseProductName();
            databaseMajorVersion = dmd.getDatabaseMajorVersion();
            databaseMinorVersion = dmd.getDatabaseMinorVersion();
            c.close();
        }
        catch (Exception e) {
            log.error("Error with connection string: " + DatabaseConfig.DATABASE_URL, (Throwable)e);
            throw new Error("DatabaseFactory not initialized!");
        }
        log.info("Successfully connected to database");
    }

    public static Connection getConnection() throws SQLException {
        Connection con = connectionPool.getConnection();
        if (!con.getAutoCommit()) {
            log.error("Connection Settings Error: Connection obtained from database factory should be in auto-commit mode. Forsing auto-commit to true. Please check source code for connections beeing not properly closed.");
            con.setAutoCommit(true);
        }
        return con;
    }

    public int getActiveConnections() {
        return connectionPool.getTotalLeased();
    }

    public int getIdleConnections() {
        return connectionPool.getStatistics().getTotalFree();
    }

    public static synchronized void shutdown() {
        try {
            connectionPool.shutdown();
        }
        catch (Exception e) {
            log.warn("Failed to shutdown DatabaseFactory", (Throwable)e);
        }
        connectionPool = null;
    }

    public static void close(PreparedStatement st, Connection con) {
        DatabaseFactory.close(st);
        DatabaseFactory.close(con);
    }

    public static void close(PreparedStatement st) {
        if (st == null) {
            return;
        }
        try {
            if (!st.isClosed()) {
                st.close();
            }
        }
        catch (SQLException e) {
            log.error("Can't close Prepared Statement", (Throwable)e);
        }
    }

    public static void close(Connection con) {
        if (con == null) {
            return;
        }
        try {
            if (!con.getAutoCommit()) {
                con.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            log.error("Failed to set autocommit to true while closing connection: ", (Throwable)e);
        }
        try {
            con.close();
        }
        catch (SQLException e) {
            log.error("DatabaseFactory: Failed to close database connection!", (Throwable)e);
        }
    }

    public static String getDatabaseName() {
        return databaseName;
    }

    public static int getDatabaseMajorVersion() {
        return databaseMajorVersion;
    }

    public static int getDatabaseMinorVersion() {
        return databaseMinorVersion;
    }

    private DatabaseFactory() {
    }
}

