/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.database;

import at.chrl.database.CallReadStH;
import at.chrl.database.DatabaseFactory;
import at.chrl.database.IUStH;
import at.chrl.database.ParamReadStH;
import at.chrl.database.ReadStH;
import at.chrl.database.Transaction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DB {
    protected static final Logger log = LoggerFactory.getLogger(DB.class);

    private DB() {
    }

    public static boolean select(String query, ReadStH reader) {
        return DB.select(query, reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean select(String query, ReadStH reader, String errMsg) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DatabaseFactory.getConnection();
            stmt = con.prepareStatement(query);
            if (reader instanceof ParamReadStH) {
                ((ParamReadStH)reader).setParams(stmt);
            }
            ResultSet rset = stmt.executeQuery();
            reader.handleRead(rset);
        }
        catch (Exception e) {
            if (errMsg == null) {
                log.warn("Error executing select query " + e, (Throwable)e);
            } else {
                log.warn(errMsg + " " + e, (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to close DB connection " + e, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean call(String query, ReadStH reader) {
        return DB.call(query, reader, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean call(String query, ReadStH reader, String errMsg) {
        Connection con = null;
        CallableStatement stmt = null;
        try {
            con = DatabaseFactory.getConnection();
            stmt = con.prepareCall(query);
            if (reader instanceof CallReadStH) {
                ((CallReadStH)reader).setParams(stmt);
            }
            ResultSet rset = stmt.executeQuery();
            reader.handleRead(rset);
        }
        catch (Exception e) {
            if (errMsg == null) {
                log.warn("Error calling stored procedure " + e, (Throwable)e);
            } else {
                log.warn(errMsg + " " + e, (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to close DB connection " + e, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean insertUpdate(String query) {
        return DB.insertUpdate(query, null, null);
    }

    public static boolean insertUpdate(String query, String errMsg) {
        return DB.insertUpdate(query, null, errMsg);
    }

    public static boolean insertUpdate(String query, IUStH batch) {
        return DB.insertUpdate(query, batch, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertUpdate(String query, IUStH batch, String errMsg) {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            con = DatabaseFactory.getConnection();
            stmt = con.prepareStatement(query);
            if (batch != null) {
                batch.handleInsertUpdate(stmt);
            } else {
                stmt.executeUpdate();
            }
        }
        catch (Exception e) {
            if (errMsg == null) {
                log.warn("Failed to execute IU query " + e, (Throwable)e);
            } else {
                log.warn(errMsg + " " + e, (Throwable)e);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {
                log.warn("Failed to close DB connection " + e, (Throwable)e);
            }
        }
        return true;
    }

    public static Transaction beginTransaction() throws SQLException {
        Connection con = DatabaseFactory.getConnection();
        return new Transaction(con);
    }

    public static PreparedStatement prepareStatement(String sql) {
        return DB.prepareStatement(sql, 1003, 1007);
    }

    public static PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) {
        PreparedStatement ps;
        block4: {
            Connection c = null;
            ps = null;
            try {
                c = DatabaseFactory.getConnection();
                ps = c.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            catch (Exception e) {
                log.error("Can't create PreparedStatement for querry: " + sql, (Throwable)e);
                if (c == null) break block4;
                try {
                    c.close();
                }
                catch (SQLException e1) {
                    log.error("Can't close connection after exception", (Throwable)e1);
                }
            }
        }
        return ps;
    }

    public static int executeUpdate(PreparedStatement statement) {
        try {
            return statement.executeUpdate();
        }
        catch (Exception e) {
            log.error("Can't execute update for PreparedStatement", (Throwable)e);
            return -1;
        }
    }

    public static void executeUpdateAndClose(PreparedStatement statement) {
        DB.executeUpdate(statement);
        DB.close(statement);
    }

    public static ResultSet executeQuerry(PreparedStatement statement) {
        ResultSet rs = null;
        try {
            rs = statement.executeQuery();
        }
        catch (Exception e) {
            log.error("Error while executing querry", (Throwable)e);
        }
        return rs;
    }

    public static void close(PreparedStatement statement) {
        try {
            if (statement.isClosed()) {
                log.warn("Attempt to close PreparedStatement that is closes already", (Throwable)new Exception());
                return;
            }
            Connection c = statement.getConnection();
            statement.close();
            c.close();
        }
        catch (Exception e) {
            log.error("Error while closing PreparedStatement", (Throwable)e);
        }
    }
}

