/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration;

import at.chrl.nutils.ArrayUtils;
import at.chrl.nutils.ClassUtils;
import at.chrl.nutils.configuration.Property;
import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.PropertyTransformerFactory;
import at.chrl.nutils.configuration.TransformationException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;
import java.util.function.Function;

public class ConfigurableProcessor {
    public static void process(Object object, Properties ... properties) {
        Class<?> clazz;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
            object = null;
        } else {
            clazz = object.getClass();
        }
        ConfigurableProcessor.process(clazz, object, properties);
    }

    private static void process(Class clazz, Object obj, Properties[] props) {
        Class superClass;
        ConfigurableProcessor.processFields(clazz, obj, props);
        if (obj == null) {
            for (Class<?> itf : clazz.getInterfaces()) {
                ConfigurableProcessor.process(itf, obj, props);
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && superClass != Object.class) {
            ConfigurableProcessor.process(superClass, obj, props);
        }
    }

    private static void processFields(Class clazz, Object obj, Properties[] props) {
        for (Field f : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) && obj != null || !Modifier.isStatic(f.getModifiers()) && obj == null || !f.isAnnotationPresent(Property.class)) continue;
            if (Modifier.isFinal(f.getModifiers())) {
                RuntimeException re = new RuntimeException("Attempt to proceed final field " + f.getName() + " of class " + clazz.getName());
                System.err.println(re.toString());
                throw re;
            }
            ConfigurableProcessor.processField(f, obj, props);
        }
    }

    private static void processField(Field f, Object obj, Properties[] props) {
        boolean oldAccessible = f.isAccessible();
        f.setAccessible(true);
        try {
            Property property = f.getAnnotation(Property.class);
            if (!"DO_NOT_OVERWRITE_INITIALIAZION_VALUE".equals(property.defaultValue()) || ConfigurableProcessor.isKeyPresent(property.key(), props)) {
                Object toSet = ConfigurableProcessor.getFieldValue(f, props);
                if (f.getType().isArray() && f.getType().getComponentType().isArray()) {
                    Class componentType = ClassUtils.getNonPrimitiveClass(f.getType().getComponentType().getComponentType());
                    Class componentType1 = ClassUtils.getNonPrimitiveClass(f.getType().getComponentType());
                    Object[] arr = (Object[])toSet;
                    Object[] setMe = (Object[])Array.newInstance(componentType1, arr.length);
                    Function function = ArrayUtils.getToPrimitive((Class)componentType);
                    boolean isPrimitiv = f.getType().getComponentType().getComponentType().isPrimitive();
                    int i = 0;
                    for (Object object : arr) {
                        Object[] arr2 = (Object[])object;
                        Object arr2New = Array.newInstance(componentType, arr2.length);
                        System.arraycopy(arr2, 0, arr2New, 0, arr2.length);
                        if (isPrimitiv) {
                            arr2New = function.apply(arr2New);
                        }
                        setMe[i++] = arr2New;
                    }
                    f.set(obj, setMe);
                } else if (f.getType().isArray()) {
                    Class componentType = ClassUtils.getNonPrimitiveClass(f.getType().getComponentType());
                    Object[] arr = (Object[])toSet;
                    Object arr2 = Array.newInstance(componentType, arr.length);
                    System.arraycopy(arr, 0, arr2, 0, arr.length);
                    if (f.getType().getComponentType().isPrimitive()) {
                        Function function = ArrayUtils.getToPrimitive((Class)componentType);
                        arr2 = function.apply(arr2);
                    }
                    f.set(obj, arr2);
                } else {
                    f.set(obj, toSet);
                }
            } else {
                System.out.println("Field " + f.getName() + " of class " + f.getDeclaringClass().getName() + " wasn't modified");
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Can't transform field " + f.getName() + " of class " + f.getDeclaringClass(), e);
            System.err.println(re.toString());
            throw re;
        }
        f.setAccessible(oldAccessible);
    }

    private static Object getFieldValue(Field field, Properties ... props) throws TransformationException {
        Property property = field.getAnnotation(Property.class);
        String defaultValue = property.defaultValue();
        String key = property.key();
        String value = null;
        if (key.isEmpty()) {
            System.out.println("Property " + field.getName() + " of class " + field.getDeclaringClass().getName() + " has empty key");
        } else {
            value = ConfigurableProcessor.findPropertyByKey(key, props);
        }
        if (value == null) {
            value = defaultValue;
            System.out.println("Using default value for field " + field.getName() + " of class " + field.getDeclaringClass().getName());
        }
        PropertyTransformer pt = PropertyTransformerFactory.newTransformer(field.getType(), property.propertyTransformer());
        return pt.transform(value, field, property.types());
    }

    static String findPropertyByKey(String key, Properties[] props) {
        for (Properties p : props) {
            if (!p.containsKey(key)) continue;
            return p.getProperty(key);
        }
        return null;
    }

    static boolean isKeyPresent(String key, Properties[] props) {
        return ConfigurableProcessor.findPropertyByKey(key, props) != null;
    }
}

