/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.transformers;

import at.chrl.nutils.Constants;
import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.TransformationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Field;

public class PrintStreamTransformer
implements PropertyTransformer<PrintStream> {
    public static final PrintStreamTransformer SHARED_INSTANCE = new PrintStreamTransformer();

    @Override
    public PrintStream transform(String value, Field field) throws TransformationException {
        switch (value = value.toLowerCase()) {
            case "standart": 
            case "default": 
            case "out": 
            case "std": 
            case "stdo": 
            case "stdout": 
            case "syso": 
            case "sysout": 
            case "system.out": {
                return System.out;
            }
            case "err": 
            case "error": 
            case "stde": 
            case "stder": 
            case "stderr": 
            case "syse": 
            case "syserr": 
            case "system.err": {
                return System.err;
            }
            case "nop": {
                return Constants.NOP_PRINT_STREAM;
            }
        }
        try {
            return new PrintStream(new File(value.endsWith(".log") ? value : value.concat(".log")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace(System.err);
            return Constants.NOP_PRINT_STREAM;
        }
    }
}

