/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.transformers;

import at.chrl.nutils.ClassUtils;
import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.TransformationException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Function;

public class FunctionTransformer<T, R>
implements PropertyTransformer<Function<T, R>> {
    public static final FunctionTransformer<Object, Object> SHARED_INSTANCE = new FunctionTransformer();
    public static final Class<?>[] EMPTY_ARRAY = new Class[0];

    @Override
    public Function<T, R> transform(String value, Field field, Class<?> ... types) throws TransformationException {
        try {
            if (!value.contains("::")) {
                throw new IllegalArgumentException("Syntax for Function Property: <class>::<method reference>");
            }
            String clazzString = value.substring(0, value.indexOf("::"));
            String methodString = value.substring(value.indexOf("::") + 2);
            Class<?> clazz = Class.forName(clazzString);
            types = (Class[])Arrays.stream(types).map(ClassUtils::getPrimitiveClass).toArray(Class[]::new);
            final Method m = clazz.getDeclaredMethod(methodString, types);
            return new Function<T, R>(){

                @Override
                public R apply(T t) {
                    try {
                        return m.invoke(null, t);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            };
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    public Function<T, R> transform(String value, Field field) throws TransformationException {
        return this.transform(value, field, (Class[])EMPTY_ARRAY);
    }
}

