/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.transformers;

import at.chrl.nutils.configuration.PropertyTransformer;
import at.chrl.nutils.configuration.PropertyTransformerFactory;
import at.chrl.nutils.configuration.TransformationException;
import at.chrl.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;

public class ArrayTransformer<T>
implements PropertyTransformer<T[]> {
    public static final ArrayTransformer<Object> SHARED_INSTANCE = new ArrayTransformer();

    @Override
    public T[] transform(String value, Field field) throws TransformationException {
        return this.transformInner(value, field.getType(), field);
    }

    private T[] transformInner(String value, Class<?> type, Field field) {
        try {
            if (type.isArray() && type.getComponentType().isArray()) {
                ArrayTransformer.validBrackets(value);
                ArrayTransformer pt = (ArrayTransformer)PropertyTransformerFactory.newTransformer(type.getComponentType(), ArrayTransformer.class);
                return Arrays.stream(ArrayTransformer.parse(value)).map(p -> pt.transformInner((String)p, type.getComponentType(), field)).toArray();
            }
            String spliter = File.pathSeparator;
            if (!(value = StringUtils.trim((String)value, (char[])new char[]{'{', '}'})).contains(spliter)) {
                spliter = ";";
            }
            if (!value.contains(spliter)) {
                spliter = ",";
            }
            if (!value.contains(spliter)) {
                spliter = " ";
            }
            return Arrays.stream(value.split(spliter)).map(s -> this.transformElement((String)s, type, field)).toArray();
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    private T transformElement(String value, Class<?> clazz, Field field) {
        PropertyTransformer pt = PropertyTransformerFactory.newTransformer(clazz.getComponentType(), PropertyTransformer.class);
        return pt.transform(value, field);
    }

    public static final String[] parse(String value) {
        String[] returnMe = new String[StringUtils.countMatches((String)value, (char)'}')];
        int j = 0;
        int i = 0;
        while (value.indexOf("{", i) < value.indexOf("}", i)) {
            returnMe[j++] = value.substring(value.indexOf("{", i) + 1, value.indexOf("}", i));
            if (value.indexOf("}", i = value.indexOf("}", i) + 1) >= 0) continue;
            return returnMe;
        }
        return returnMe;
    }

    public static final boolean validBrackets(String v) {
        String value = StringUtils.trim((String)v, (char[])new char[]{' '});
        if (!value.startsWith("{") || !value.endsWith("}")) {
            throw new IllegalArgumentException("Syntax Erro: Property Value doesn't start with '{' or ends with '}'");
        }
        if (StringUtils.countMatches((String)value, (char)'{') != StringUtils.countMatches((String)value, (char)'}')) {
            throw new IllegalArgumentException("Syntax Error: Brackets not valid");
        }
        if (!(StringUtils.countMatches((String)value, (char)'{') <= 1 || value.contains("}, {") || value.contains("} ,{") || value.contains("},{") || value.contains("} , {") || value.contains("}{") || value.contains("} {"))) {
            throw new IllegalArgumentException("Syntax Error: Multiple Array Syntax not valid | try: \" ...}, {....\"");
        }
        int i = 0;
        while (value.indexOf("{", i) < value.indexOf("}", i)) {
            if (value.indexOf("}", i = value.indexOf("}", i) + 1) >= 0) continue;
            return true;
        }
        throw new IllegalArgumentException("Syntax Error: Only 2D Arrays supportet now");
    }
}

