/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration.printer;

import at.chrl.nutils.JVMInfoUtil;
import at.chrl.nutils.configuration.IConfigPrinter;
import at.chrl.nutils.configuration.Property;
import at.chrl.utils.StringUtils;
import java.io.PrintStream;

public class PrintStreamPrinter
implements IConfigPrinter {
    final PrintStream ps;

    public PrintStreamPrinter(PrintStream ps) {
        this.ps = ps;
    }

    @Override
    public <T> void printConfigField(Property property, String currentValue, Class<T> annotatedType) {
        this.ps.println("# " + JVMInfoUtil.printSection((String)property.key()));
        this.ps.println("# Description:");
        this.ps.println("# " + StringUtils.insertRepetitive((String)property.description(), (int)(102 - (property.key().length() + 6)), (String)"\n# "));
        this.ps.println();
        if (property.examples().length > 0) {
            this.ps.println("# Examples:" + System.lineSeparator());
            for (String example : property.examples()) {
                this.ps.println("# " + example + System.lineSeparator());
            }
            this.ps.println("# " + System.lineSeparator());
        } else if (annotatedType.isEnum()) {
            this.ps.println("# Valid Examples:" + System.lineSeparator());
            for (T example : annotatedType.getEnumConstants()) {
                this.ps.println("# " + example.toString() + System.lineSeparator());
            }
            this.ps.println("# " + System.lineSeparator());
        }
        this.ps.println("# Default Value: " + property.defaultValue());
        this.ps.println(property.key() + "=" + currentValue);
        this.ps.println();
    }
}

