/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration;

import at.chrl.nutils.Constants;
import at.chrl.nutils.configuration.ConfigurableProcessor;
import at.chrl.nutils.configuration.IConfigPrinter;
import at.chrl.nutils.configuration.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Properties;

public class ConfigurationExporter {
    public static void process(Object object, IConfigPrinter os, Properties ... props) {
        Class<?> clazz;
        if (object instanceof Class) {
            clazz = (Class<?>)object;
            object = null;
        } else {
            clazz = object.getClass();
        }
        ConfigurationExporter.process(clazz, object, os, props);
    }

    protected static void process(Class clazz, Object obj, IConfigPrinter os, Properties ... props) {
        Class superClass;
        ConfigurationExporter.processFields(clazz, obj, os, props);
        if (obj == null) {
            for (Class<?> itf : clazz.getInterfaces()) {
                ConfigurationExporter.process(itf, obj, os, props);
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && superClass != Object.class) {
            ConfigurationExporter.process(superClass, obj, os, props);
        }
    }

    static void processFields(Class clazz, Object obj, IConfigPrinter os, Properties ... props) {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Property.class)) continue;
            if (Modifier.isFinal(f.getModifiers())) {
                RuntimeException re = new RuntimeException("Attempt to proceed final field " + f.getName() + " of class " + clazz.getName());
                Constants.log.error((Object)re.toString(), new Throwable[0]);
                throw re;
            }
            ConfigurationExporter.processField(f, obj, os, props);
        }
    }

    private static void processField(Field f, Object obj, IConfigPrinter os, Properties ... props) {
        boolean oldAccessible = f.isAccessible();
        f.setAccessible(true);
        try {
            Property property = f.getAnnotation(Property.class);
            if (obj != null) {
                os.printConfigField(property, f.get(obj).toString(), f.getType());
            } else if (ConfigurableProcessor.isKeyPresent(property.key(), props)) {
                os.printConfigField(property, ConfigurableProcessor.findPropertyByKey(property.key(), props), f.getType());
            } else {
                os.printConfigField(property, property.defaultValue(), f.getType());
            }
        }
        catch (Exception e) {
            RuntimeException re = new RuntimeException("Can't print field " + f.getName() + " of class " + f.getDeclaringClass(), e);
            Constants.log.error((Object)re.toString(), new Throwable[0]);
            throw re;
        }
        f.setAccessible(oldAccessible);
    }
}

