/*
 * Decompiled with CFR 0.152.
 */
package at.chrl.nutils.configuration;

import at.chrl.nutils.configuration.ConfigurableProcessor;
import at.chrl.nutils.configuration.ConfigurationExporter;
import at.chrl.nutils.configuration.IConfigPrinter;
import at.chrl.nutils.configuration.PropertiesUtils;
import at.chrl.nutils.configuration.printer.PropertyFileStreamPrinter;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public final class ConfigUtil {
    private static Collection<File> propertiesFiles;
    private static final LinkedList<Class<?>> classes;
    private static Properties[] props;
    private static File configDirectory;
    private static Map<Class<?>, File> exportedFiles;

    static final Properties[] loadPropertiesFiles() {
        try {
            return PropertiesUtils.load(propertiesFiles.toArray(new File[propertiesFiles.size()]));
        }
        catch (IOException e) {
            System.err.println("Error loading Properties");
            e.printStackTrace();
            return props;
        }
    }

    public static final synchronized void loadAndExport(Class<?> targetClass) {
        ConfigUtil.load(targetClass);
        ConfigUtil.export(targetClass);
    }

    public static final synchronized void loadAndExport(Object obj) {
        ConfigUtil.load(obj);
        ConfigUtil.export(obj.getClass());
    }

    public static final synchronized void export(Class<?> classToExport) {
        File toExport = new File(configDirectory, classToExport.getSimpleName() + ".properties");
        ConfigUtil.export(classToExport, new PropertyFileStreamPrinter(toExport));
        exportedFiles.put(classToExport, toExport);
    }

    public static final synchronized void export(Class<?> classToExport, IConfigPrinter printer) {
        ConfigurationExporter.process(classToExport, printer, ConfigUtil.getLoadedProperties(classToExport));
    }

    public static final synchronized void export(Object obj) {
        File toExport = new File(configDirectory, obj.getClass().getSimpleName() + ".properties");
        ConfigurationExporter.process(obj, new PropertyFileStreamPrinter(toExport), new Properties[0]);
        exportedFiles.put(obj.getClass(), toExport);
    }

    public static final synchronized void load(Class<?> classToLoad) {
        ConfigurableProcessor.process(classToLoad, ConfigUtil.getLoadedProperties(classToLoad));
        if (!classes.contains(classToLoad)) {
            classes.add(classToLoad);
        }
    }

    public static final synchronized void load(Object obj) {
        Class<?> classToLoad = obj.getClass();
        ConfigurableProcessor.process(obj, ConfigUtil.getLoadedProperties(classToLoad));
        if (!classes.contains(classToLoad)) {
            classes.add(classToLoad);
        }
    }

    private static Properties[] getLoadedProperties(Class<?> classToLoad) {
        for (File file : propertiesFiles) {
            if (!file.getName().equals(classToLoad.getSimpleName() + ".properties")) continue;
            try {
                return new Properties[]{PropertiesUtils.load(file)};
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    public static final void reload() {
        props = ConfigUtil.loadPropertiesFiles();
        for (Class clazz : classes) {
            ConfigUtil.load(clazz);
        }
    }

    public static final void reload(Class<?> classToReload) {
        props = ConfigUtil.loadPropertiesFiles();
        ConfigUtil.load(classToReload);
    }

    private ConfigUtil() {
    }

    public static synchronized File getConfigDirectory() {
        return configDirectory;
    }

    public static synchronized void setConfigDirectory(File configDirectory) {
        if (Objects.isNull(configDirectory)) {
            throw new IllegalArgumentException("Configuration folder passed as parameter is null");
        }
        if (!configDirectory.exists()) {
            throw new IllegalArgumentException("Configuration folder does not exist: " + configDirectory.getAbsolutePath());
        }
        if (!configDirectory.isDirectory()) {
            throw new IllegalArgumentException("Configuration folder is not a directory: " + configDirectory.getAbsolutePath());
        }
        if (!configDirectory.canWrite()) {
            throw new IllegalArgumentException("Cannot write to configuration folder: " + configDirectory.getAbsolutePath());
        }
        if (!configDirectory.canRead()) {
            throw new IllegalArgumentException("Cannot read from configuration folder: " + configDirectory.getAbsolutePath());
        }
        ConfigUtil.configDirectory = configDirectory;
        propertiesFiles = FileUtils.listFiles((File)configDirectory, (String[])new String[]{"properties"}, (boolean)true);
        ConfigUtil.reload();
        for (Class clazz : classes) {
            ConfigUtil.export(clazz);
        }
    }

    public static void setConfigDirectory(String configDirectory) {
        if (Objects.isNull(configDirectory)) {
            throw new IllegalArgumentException("Configuration folder passed as parameter is null");
        }
        if (configDirectory.isEmpty()) {
            throw new IllegalArgumentException("Configuration folder passed as parameter is a empty String");
        }
        ConfigUtil.setConfigDirectory(new File(configDirectory));
    }

    public static synchronized Properties getProperties(Class<?> targetClass) {
        if (exportedFiles.containsKey(targetClass)) {
            try {
                return PropertiesUtils.load(exportedFiles.get(targetClass));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ConfigUtil.loadAndExport(targetClass);
        if (exportedFiles.containsKey(targetClass)) {
            try {
                return PropertiesUtils.load(exportedFiles.get(targetClass));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return new Properties();
    }

    static {
        classes = new LinkedList();
        props = new Properties[0];
        exportedFiles = new HashMap();
        propertiesFiles = FileUtils.listFiles((File)new File("."), (String[])new String[]{"properties"}, (boolean)true);
        props = ConfigUtil.loadPropertiesFiles();
    }
}

