/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.patch;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchTarget;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgAdd;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemove;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgWcToWcCopy;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnDiffHunk;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnHunkInfo;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatch;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnPropertiesPatchTarget;
import org.tmatesoft.svn.core.internal.wc2.patch.SvnTargetContent;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnPatchTarget
extends SvnTargetContent {
    private static final int MAX_FUZZ = 2;
    private File absPath;
    private File relPath;
    private File patchedAbsPath;
    private File rejectAbsPath;
    private File moveTargetAbsPath;
    private boolean filtered;
    private boolean skipped;
    private boolean hasTextChanges;
    private boolean added;
    private boolean deleted;
    private boolean hasPropChanges;
    private Map<String, SvnPropertiesPatchTarget> propTargets = new HashMap<String, SvnPropertiesPatchTarget>();
    private boolean special;
    private boolean symlink;
    private boolean replaced;
    private boolean locallyDeleted;
    private SVNNodeKind kindOnDisk;
    private SVNNodeKind dbKind;
    private boolean hasLocalModifications;
    private boolean hadRejects;
    private boolean hadPropRejects;
    private boolean executable;
    private File canonPathFromPatchfile;
    private String eolStr;
    private SVNPatchFileStream stream;
    private SVNPatchFileStream patchedStream;
    private SVNPatchFileStream rejectStream;

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean hasTextChanges() {
        return this.hasTextChanges;
    }

    public boolean isAdded() {
        return this.added;
    }

    public File getAbsPath() {
        return this.absPath;
    }

    public File getMoveTargetAbsPath() {
        return this.moveTargetAbsPath;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean hasPropChanges() {
        return this.hasPropChanges;
    }

    public void setSpecial(boolean special) {
        this.special = special;
    }

    public Map<String, SvnPropertiesPatchTarget> getPropTargets() {
        return this.propTargets;
    }

    public String getEolStr() {
        return this.eolStr;
    }

    public File getRejectAbsPath() {
        return this.rejectAbsPath;
    }

    public void setRejectAbsPath(File rejectAbsPath) {
        this.rejectAbsPath = rejectAbsPath;
    }

    public SVNPatchFileStream getStream() {
        return this.stream;
    }

    public SVNPatchFileStream getPatchedStream() {
        return this.patchedStream;
    }

    public void setPatchedStream(SVNPatchFileStream patchedStream) {
        this.patchedStream = patchedStream;
    }

    public SVNPatchFileStream getRejectStream() {
        return this.rejectStream;
    }

    public void setRejectStream(SVNPatchFileStream rejectStream) {
        this.rejectStream = rejectStream;
    }

    public static SvnPatchTarget applyPatch(SvnPatch patch, File workingCopyDirectory, int stripCount, SVNWCContext context, boolean ignoreWhitespace, boolean removeTempFiles) throws SVNException, IOException {
        SvnPatchTarget target = SvnPatchTarget.initPatchTarget(patch, workingCopyDirectory, stripCount, removeTempFiles, context);
        if (target.isSkipped()) {
            return target;
        }
        List hunks = patch.getHunks();
        for (SvnDiffHunk svnDiffHunk : hunks) {
            SvnHunkInfo svnHunkInfo;
            int fuzz = 0;
            while ((svnHunkInfo = target.getHunkInfo(svnDiffHunk, target, fuzz, ignoreWhitespace, false)).isRejected() && ++fuzz <= 2 && !svnHunkInfo.isAlreadyApplied()) {
            }
            target.addHunkInfo(svnHunkInfo);
        }
        for (SvnHunkInfo svnHunkInfo : target.getHunkInfos()) {
            if (svnHunkInfo.isAlreadyApplied()) continue;
            if (svnHunkInfo.isRejected()) {
                SvnPatchTarget.rejectHunk(target, svnHunkInfo.getHunk(), null);
                continue;
            }
            SvnPatchTarget.applyHunk(target, target, svnHunkInfo, null);
        }
        if (target.getKindOnDisk() == SVNNodeKind.FILE) {
            SvnPatchTarget.copyLinesToTarget(target, 0);
            if (!target.isEof()) {
                target.setSkipped(true);
            }
        }
        for (Map.Entry entry : patch.getPropPatches().entrySet()) {
            String string = (String)entry.getKey();
            SvnPropertiesPatch propPatch = (SvnPropertiesPatch)entry.getValue();
            if ("svn:special".equals(string)) {
                target.setSpecial(true);
            }
            Map<String, SvnPropertiesPatchTarget> propTargets = target.getPropTargets();
            SvnPropertiesPatchTarget propTarget = propTargets.get(string);
            List propPatchHunks = propPatch.getHunks();
            for (SvnDiffHunk hunk : propPatchHunks) {
                SvnHunkInfo hunkInfo;
                int fuzz = 0;
                while ((hunkInfo = target.getHunkInfo(hunk, (SvnTargetContent)propTarget, fuzz, ignoreWhitespace, true)).isRejected() && ++fuzz <= 2 && !hunkInfo.isAlreadyApplied()) {
                }
                propTarget.addHunkInfo(hunkInfo);
            }
        }
        Map<String, SvnPropertiesPatchTarget> propTargets = target.getPropTargets();
        for (Map.Entry<String, SvnPropertiesPatchTarget> entry : propTargets.entrySet()) {
            SvnPropertiesPatchTarget propTarget = entry.getValue();
            List hunkInfos = propTarget.getHunkInfos();
            for (SvnHunkInfo hunkInfo : hunkInfos) {
                if (hunkInfo.isAlreadyApplied()) continue;
                if (hunkInfo.isRejected()) {
                    SvnPatchTarget.rejectHunk(target, hunkInfo.getHunk(), propTarget.getName());
                    continue;
                }
                SvnPatchTarget.applyHunk(target, (SvnTargetContent)propTarget, hunkInfo, propTarget.getName());
            }
            if (!propTarget.isExisted()) continue;
            SvnPatchTarget.copyLinesToTarget((SvnTargetContent)propTarget, 0);
            if (propTarget.isEof()) continue;
            target.setSkipped(true);
        }
        if (!target.isSymlink()) {
            if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                target.getStream().close();
            }
            target.getPatchedStream().close();
        }
        if (!target.isSkipped()) {
            long l = SVNFileUtil.getFileLength((File)target.getPatchedAbsPath());
            long workingFileSize = target.getKindOnDisk() == SVNNodeKind.FILE ? SVNFileUtil.getFileLength((File)target.getAbsPath()) : 0L;
            if (l == 0L && workingFileSize > 0L) {
                target.setDeleted(target.getDbKind() == SVNNodeKind.FILE);
            } else if (l == 0L && workingFileSize == 0L) {
                if (target.getKindOnDisk() == SVNNodeKind.NONE && !target.hasPropChanges() && !target.isAdded()) {
                    target.setSkipped(true);
                }
            } else if (l > 0L && workingFileSize == 0L) {
                if (target.isLocallyDeleted()) {
                    target.setReplaced(true);
                } else if (target.getDbKind() == SVNNodeKind.NONE) {
                    target.setAdded(true);
                }
            }
        }
        return target;
    }

    private static void rejectHunk(SvnPatchTarget target, SvnDiffHunk hunk, String propName) throws SVNException {
        try {
            String atat;
            String textAtat = "@@";
            String propAtat = "##";
            if (propName != null) {
                String propHeader = "Property: " + propName + "\n";
                target.getRejectStream().write(propHeader);
                atat = propAtat;
            } else {
                atat = textAtat;
            }
            String hunkHeader = String.format("%s -%s,%s +%s,%s %s\n", atat, hunk.getDirectedOriginalStart(), hunk.getDirectedOriginalLength(), hunk.getDirectedModifiedStart(), hunk.getDirectedModifiedLength(), atat);
            target.getRejectStream().write(hunkHeader);
            boolean[] eof = new boolean[1];
            String[] eolStr = new String[1];
            do {
                String hunkLine = hunk.readLineDiffText(eolStr, eof);
                if (eof[0]) continue;
                if (hunkLine.length() >= 1) {
                    target.getRejectStream().write(hunkLine);
                }
                if (eolStr[0] == null) continue;
                target.getRejectStream().write(eolStr[0]);
            } while (!eof[0]);
            if (propName != null) {
                target.setHadPropRejects(true);
            } else {
                target.setHadRejects(true);
            }
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
            SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
        }
    }

    private static void applyHunk(SvnPatchTarget target, SvnTargetContent targetContent, SvnHunkInfo hunkInfo, String propName) throws SVNException {
        if (target.getKindOnDisk() == SVNNodeKind.FILE || propName != null) {
            SvnPatchTarget.copyLinesToTarget(targetContent, hunkInfo.getMatchedLine() + hunkInfo.getFuzz());
            int line = targetContent.getCurrentLine() + hunkInfo.getHunk().getDirectedOriginalLength() - 2 * hunkInfo.getFuzz();
            targetContent.seekToLine(line);
            if (targetContent.getCurrentLine() != line && !targetContent.isEof()) {
                hunkInfo.setRejected(true);
                SvnPatchTarget.rejectHunk(target, hunkInfo.getHunk(), propName);
                return;
            }
        }
        int linesRead = 0;
        hunkInfo.getHunk().resetModifiedText();
        boolean[] eof = new boolean[1];
        do {
            String[] eolStr = new String[1];
            String hunkLine = hunkInfo.getHunk().readLineModifiedText(eolStr, eof);
            if (++linesRead <= hunkInfo.getFuzz() || linesRead > hunkInfo.getHunk().getDirectedModifiedLength() - hunkInfo.getFuzz()) continue;
            if (hunkLine.length() >= 1) {
                targetContent.getWriteCallback().write(target.getWriteBaton(), hunkLine);
            }
            if (eolStr[0] == null) continue;
            if (targetContent.getEolStyle() != SVNWCContext.SVNEolStyle.None) {
                eolStr[0] = targetContent.getEolStr();
            }
            targetContent.getWriteCallback().write(target.getWriteBaton(), eolStr[0]);
        } while (!eof[0]);
        if (propName != null) {
            target.setHasPropChanges(true);
        } else {
            target.setHasTextChanges(true);
        }
    }

    private SvnHunkInfo getHunkInfo(SvnDiffHunk hunk, SvnTargetContent targetContent, int fuzz, boolean ignoreWhitespace, boolean isPropHunk) throws SVNException {
        int matchedLine;
        int originalStart = hunk.getDirectedOriginalStart();
        boolean alreadyApplied = false;
        if (originalStart == 0 && fuzz > 0) {
            matchedLine = 0;
        } else if (originalStart == 0 && !isPropHunk) {
            if (this.getKindOnDisk() == SVNNodeKind.FILE) {
                SVNFileType kind = SVNFileType.getType((File)this.getAbsPath());
                boolean special = kind == SVNFileType.SYMLINK;
                long fileLength = SVNFileUtil.getFileLength((File)this.getAbsPath());
                if (kind == SVNFileType.FILE && !special && fileLength == 0L) {
                    matchedLine = 1;
                } else if (this.getDbKind() == SVNNodeKind.FILE) {
                    boolean fileMatches = targetContent.matchExistingTarget(hunk);
                    if (fileMatches) {
                        matchedLine = 1;
                        alreadyApplied = true;
                    } else {
                        matchedLine = 0;
                    }
                } else {
                    matchedLine = 0;
                }
            } else {
                matchedLine = 1;
            }
        } else if (originalStart == 0 && isPropHunk) {
            if (targetContent.isExisted()) {
                boolean propMatches = targetContent.matchExistingTarget(hunk);
                if (propMatches) {
                    matchedLine = 1;
                    alreadyApplied = true;
                } else {
                    matchedLine = 0;
                }
            } else {
                matchedLine = 1;
            }
        } else if (originalStart > 0 && targetContent.isExisted()) {
            int savedLine = targetContent.getCurrentLine();
            targetContent.seekToLine(originalStart);
            matchedLine = targetContent.getCurrentLine() != originalStart ? 0 : targetContent.scanForMatch(hunk, true, originalStart + 1, fuzz, ignoreWhitespace, false, null);
            if (matchedLine != originalStart) {
                if (fuzz == 0) {
                    int modifiedStart = hunk.getDirectedModifiedStart();
                    if (modifiedStart == 0) {
                        alreadyApplied = this.isLocallyDeleted();
                    } else {
                        targetContent.seekToLine(modifiedStart);
                        matchedLine = targetContent.scanForMatch(hunk, true, modifiedStart + 1, fuzz, ignoreWhitespace, true, null);
                        alreadyApplied = matchedLine == modifiedStart;
                    }
                } else {
                    alreadyApplied = false;
                }
                if (!alreadyApplied) {
                    targetContent.seekToLine(1);
                    matchedLine = targetContent.scanForMatch(hunk, false, originalStart, fuzz, ignoreWhitespace, false, null);
                    if (matchedLine == 0) {
                        matchedLine = targetContent.scanForMatch(hunk, true, 0, fuzz, ignoreWhitespace, false, null);
                    }
                }
            }
            targetContent.seekToLine(savedLine);
        } else {
            matchedLine = 0;
        }
        return new SvnHunkInfo(hunk, matchedLine, matchedLine == 0, alreadyApplied, fuzz);
    }

    private static void copyLinesToTarget(SvnTargetContent target, int line) throws SVNException {
        while (!(target.getCurrentLine() >= line && line != 0 || target.isEof())) {
            String targetLine = target.readLine();
            if (!target.isEof()) {
                targetLine = targetLine + target.getEolStr();
            }
            target.getWriteCallback().write(target.getWriteBaton(), targetLine);
        }
    }

    private static SvnPatchTarget initPatchTarget(SvnPatch patch, File workingCopyDirectory, int stripCount, boolean removeTempFiles, SVNWCContext context) throws SVNException, IOException {
        boolean hasPropChanges = false;
        boolean propChangesOnly = false;
        for (Map.Entry entry : patch.getPropPatches().entrySet()) {
            SvnPropertiesPatch propPatch = (SvnPropertiesPatch)entry.getValue();
            if (hasPropChanges) break;
            hasPropChanges = propPatch.getHunks().size() > 0;
        }
        propChangesOnly = hasPropChanges && patch.getHunks().size() == 0;
        SvnPatchTarget target = new SvnPatchTarget();
        target.setCurrentLine(1);
        target.setEolStyle(SVNWCContext.SVNEolStyle.None);
        target.setDbKind(SVNNodeKind.NONE);
        target.setKindOnDisk(SVNNodeKind.NONE);
        target.resolveTargetPath(SvnPatchTarget.chooseTargetFilename(patch), workingCopyDirectory, stripCount, propChangesOnly, context);
        if (!target.isSkipped()) {
            File uniqueFile;
            if (target.isSymlink()) {
                target.setExisted(true);
                target.setReadBaton(new SymlinkReadBaton(target.getAbsPath()));
                SymlinkCallbacks symlinkCallbacks = new SymlinkCallbacks(workingCopyDirectory, context);
                target.setReadLineCallback(symlinkCallbacks);
                target.setTellCallback(symlinkCallbacks);
                target.setSeekCallback(symlinkCallbacks);
            } else if (target.getKindOnDisk() == SVNNodeKind.FILE) {
                target.setHasLocalModifications(context.isTextModified(target.getAbsPath(), false));
                target.setExecutable(SVNFileUtil.isExecutable((File)target.getAbsPath()));
                HashMap<String, byte[]> keywords = new HashMap<String, byte[]>();
                SVNWCContext.SVNEolStyle[] eolStyle = new SVNWCContext.SVNEolStyle[1];
                String[] eolStr = new String[1];
                if (target.getKeywords() != null) {
                    keywords.putAll(target.getKeywords());
                }
                eolStyle[0] = target.getEolStyle();
                eolStr[0] = target.getEolStr();
                SvnPatchTarget.obtainEolAndKeywordsForFile(keywords, eolStyle, eolStr, context, target.getAbsPath());
                target.setKeywords(keywords);
                target.setEolStyle(eolStyle[0]);
                target.setEolStr(eolStr[0]);
                RegularCallbacks regularCallbacks = new RegularCallbacks();
                target.setExisted(true);
                target.setReadLineCallback(regularCallbacks);
                target.setSeekCallback(regularCallbacks);
                target.setTellCallback(regularCallbacks);
                target.setStream(SVNPatchFileStream.openReadOnly((File)target.getAbsPath()));
                target.setReadBaton(target.getStream());
            }
            if (patch.getOperation() == SvnDiffCallback.OperationKind.Added) {
                target.setAdded(true);
            } else if (patch.getOperation() == SvnDiffCallback.OperationKind.Deleted) {
                target.setDeleted(true);
            } else if (patch.getOperation() == SvnDiffCallback.OperationKind.Moved) {
                boolean underRoot;
                File moveTargetRelPath;
                File moveTargetPath = patch.getNewFileName();
                if (stripCount > 0) {
                    moveTargetPath = SVNPatchTarget.stripPath((File)moveTargetPath, (int)stripCount);
                }
                if (SVNFileUtil.isAbsolute((File)moveTargetPath)) {
                    moveTargetRelPath = SVNFileUtil.createFilePath((String)SVNPathUtil.getPathAsChild((String)SVNFileUtil.getFilePath((File)workingCopyDirectory), (String)SVNFileUtil.getFilePath((File)moveTargetPath)));
                    if (moveTargetRelPath == null) {
                        target.setSkipped(true);
                        target.setAbsPath(null);
                        return null;
                    }
                } else {
                    moveTargetRelPath = moveTargetPath;
                }
                if (!(underRoot = SvnPatchTarget.isUnderRoot(workingCopyDirectory, moveTargetRelPath))) {
                    target.setSkipped(true);
                    target.setAbsPath(null);
                    return target;
                }
                target.setAbsPath(SVNFileUtil.createFilePath((File)workingCopyDirectory, (File)moveTargetRelPath));
                SVNNodeKind kindOnDisk = SVNFileType.getNodeKind((SVNFileType)SVNFileType.getType((File)target.getMoveTargetAbsPath()));
                SVNNodeKind wcKind = context.readKind(target.getMoveTargetAbsPath(), false);
                if (kindOnDisk != SVNNodeKind.NONE || wcKind != SVNNodeKind.NONE) {
                    target.setSkipped(true);
                    target.setAbsPath(null);
                    return target;
                }
            }
            if (!target.isSymlink()) {
                uniqueFile = SvnPatchTarget.createTempFile(workingCopyDirectory, context);
                target.setPatchedAbsPath(uniqueFile);
                target.setPatchedStream(SVNPatchFileStream.openForWrite((File)uniqueFile));
                target.setWriteBaton(target.getPatchedStream());
                target.setWriteCallback(new RegularWriteCallback());
            } else {
                uniqueFile = SvnPatchTarget.createTempFile(workingCopyDirectory, context);
                target.setPatchedAbsPath(uniqueFile);
                target.setWriteBaton(uniqueFile);
                target.setWriteCallback(new SymlinkCallbacks(workingCopyDirectory, context));
            }
            target.setRejectAbsPath(SvnPatchTarget.createTempFile(workingCopyDirectory, context));
            target.setRejectStream(SVNPatchFileStream.openForWrite((File)target.getRejectAbsPath()));
            String diffHeader = "--- " + target.getCanonPathFromPatchfile() + "\n" + "+++ " + target.getCanonPathFromPatchfile() + "\n";
            SVNFileUtil.writeToFile((File)target.getRejectAbsPath(), (String)diffHeader, (String)"UTF-8");
            target.getRejectStream().write(diffHeader);
            if (!target.isSkipped()) {
                Map propPatches = patch.getPropPatches();
                for (Map.Entry entry : propPatches.entrySet()) {
                    String propName = (String)entry.getKey();
                    SvnPropertiesPatch propPatch = (SvnPropertiesPatch)entry.getValue();
                    SvnPropertiesPatchTarget propTarget = SvnPropertiesPatchTarget.initPropTarget((String)propName, (SvnDiffCallback.OperationKind)propPatch.getOperation(), (SVNWCContext)context, (File)target.getAbsPath());
                    target.putPropTarget(propName, propTarget);
                }
            }
        }
        return target;
    }

    private static void obtainEolAndKeywordsForFile(Map<String, byte[]> keywords, SVNWCContext.SVNEolStyle[] eolStyle, String[] eolStr, SVNWCContext context, File localAbsPath) throws SVNException {
        SVNPropertyValue eolStyleVal;
        SVNProperties actualProps = context.getActualProps(localAbsPath);
        SVNPropertyValue keywordsVal = actualProps.getSVNPropertyValue("svn:keywords");
        if (keywordsVal != null) {
            ISVNWCDb.WCDbInfo nodeChangedInfo = context.getNodeChangedInfo(localAbsPath);
            long changedRev = nodeChangedInfo.changedRev;
            SVNDate changedDate = nodeChangedInfo.changedDate;
            String changedAuthor = nodeChangedInfo.changedAuthor;
            SVNURL url = context.getNodeUrl(localAbsPath);
            SVNWCContext.SVNWCNodeReposInfo nodeReposInfo = context.getNodeReposInfo(localAbsPath);
            SVNURL reposRootUrl = nodeReposInfo.reposRootUrl;
            if (keywords != null) {
                keywords.putAll(SVNTranslator.computeKeywords((String)SVNPropertyValue.getPropertyAsString((SVNPropertyValue)keywordsVal), (String)(url == null ? null : url.toString()), (String)(reposRootUrl == null ? null : reposRootUrl.toString()), (String)changedAuthor, (String)changedDate.format(), (String)String.valueOf(changedRev), null));
            }
        }
        if ((eolStyleVal = actualProps.getSVNPropertyValue("svn:eol-style")) != null) {
            String eolStyleValString = SVNPropertyValue.getPropertyAsString((SVNPropertyValue)eolStyleVal);
            SVNWCContext.SVNEolStyleInfo eolStyleInfo = SVNWCContext.SVNEolStyleInfo.fromValue((String)eolStyleValString);
            if (eolStr != null) {
                eolStr[0] = new String(eolStyleInfo.eolStr);
            }
            if (eolStyle != null) {
                eolStyle[0] = eolStyleInfo.eolStyle;
            }
        }
    }

    private void resolveTargetPath(File pathFromPatchFile, File workingCopyDirectory, int stripCount, boolean propChangesOnly, SVNWCContext context) throws SVNException, IOException {
        SvnStatus status;
        boolean isUnderRoot;
        File canonPathFromPatchfile = pathFromPatchFile;
        this.setCanonPathFromPatchfile(canonPathFromPatchfile);
        if (!propChangesOnly && SVNFileUtil.getFilePath((File)canonPathFromPatchfile).length() == 0) {
            this.setSkipped(true);
            this.setAbsPath(null);
            this.setRelPath(SVNFileUtil.createFilePath((String)""));
            return;
        }
        File strippedPath = stripCount > 0 ? SVNPatchTarget.stripPath((File)canonPathFromPatchfile, (int)stripCount) : canonPathFromPatchfile;
        if (SVNFileUtil.isAbsolute((File)strippedPath)) {
            this.setRelPath(SVNFileUtil.createFilePath((String)SVNPathUtil.getPathAsChild((String)SVNFileUtil.getFilePath((File)workingCopyDirectory), (String)SVNFileUtil.getFilePath((File)strippedPath))));
            if (this.getRelPath() == null) {
                this.setSkipped(true);
                this.setAbsPath(null);
                this.setRelPath(strippedPath);
                return;
            }
        } else {
            this.setRelPath(strippedPath);
        }
        if (!(isUnderRoot = SvnPatchTarget.isUnderRoot(workingCopyDirectory, this.getRelPath()))) {
            this.setSkipped(true);
            this.setAbsPath(null);
            return;
        }
        this.setAbsPath(SVNFileUtil.createFilePath((File)workingCopyDirectory, (File)this.getRelPath()));
        try {
            status = SVNStatusEditor17.internalStatus((SVNWCContext)context, (File)this.getAbsPath());
            if (status.getNodeStatus() == SVNStatusType.STATUS_IGNORED || status.getNodeStatus() == SVNStatusType.STATUS_UNVERSIONED || status.getNodeStatus() == SVNStatusType.MISSING || status.getNodeStatus() == SVNStatusType.OBSTRUCTED || status.isConflicted()) {
                this.setSkipped(true);
                return;
            }
            if (status.getNodeStatus() == SVNStatusType.STATUS_DELETED) {
                this.setLocallyDeleted(true);
            }
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            this.setLocallyDeleted(true);
            this.setDbKind(SVNNodeKind.NONE);
            status = null;
        }
        if (status != null && status.getKind() != SVNNodeKind.UNKNOWN) {
            this.setDbKind(status.getKind());
        } else {
            this.setDbKind(SVNNodeKind.NONE);
        }
        SVNFileType fileType = SVNFileType.getType((File)this.getAbsPath());
        this.setSymlink(fileType == SVNFileType.SYMLINK);
        this.setKindOnDisk(SVNFileType.getNodeKind((SVNFileType)fileType));
        if (this.isLocallyDeleted()) {
            SVNWCContext.NodeMovedAway nodeMovedAway = context.nodeWasMovedAway(this.getAbsPath());
            if (nodeMovedAway != null && nodeMovedAway.movedToAbsPath != null) {
                this.setAbsPath(nodeMovedAway.movedToAbsPath);
                this.setRelPath(SVNFileUtil.skipAncestor((File)workingCopyDirectory, (File)nodeMovedAway.movedToAbsPath));
                assert (this.getRelPath() != null && this.getRelPath().getPath().length() > 0);
                this.setLocallyDeleted(false);
                fileType = SVNFileType.getType((File)this.getAbsPath());
                this.setSymlink(fileType == SVNFileType.SYMLINK);
                this.setKindOnDisk(SVNFileType.getNodeKind((SVNFileType)fileType));
            } else if (this.getKindOnDisk() != SVNNodeKind.NONE) {
                this.setSkipped(true);
                return;
            }
        }
    }

    private static boolean isUnderRoot(File workingCopyDirectory, File relPath) throws SVNException {
        File fullPath = SVNFileUtil.createFilePath((File)workingCopyDirectory, (File)relPath);
        try {
            String workingCopyDirectoryPath = SVNFileUtil.getFilePath((File)workingCopyDirectory.getCanonicalFile());
            String canonicalFullPath = SVNFileUtil.getFilePath((File)fullPath.getCanonicalFile());
            return canonicalFullPath.equals(workingCopyDirectoryPath) || SVNPathUtil.isAncestor((String)workingCopyDirectoryPath, (String)canonicalFullPath);
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
            SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
            return false;
        }
    }

    private static File chooseTargetFilename(SvnPatch patch) {
        int newCount;
        if (patch.getOldFileName().getPath().equals("/dev/null")) {
            return patch.getNewFileName();
        }
        if (patch.getNewFileName().getPath().equals("/dev/null")) {
            return patch.getOldFileName();
        }
        if (patch.getOperation() == SvnDiffCallback.OperationKind.Moved) {
            return patch.getOldFileName();
        }
        int oldCount = SVNPathUtil.getSegmentsCount((String)SVNFileUtil.getFilePath((File)patch.getOldFileName()));
        if (oldCount == (newCount = SVNPathUtil.getSegmentsCount((String)SVNFileUtil.getFilePath((File)patch.getNewFileName()))) && (oldCount = SVNPathUtil.tail((String)SVNFileUtil.getFilePath((File)patch.getOldFileName())).length()) == (newCount = SVNPathUtil.tail((String)SVNFileUtil.getFilePath((File)patch.getNewFileName())).length())) {
            oldCount = SVNFileUtil.getFilePath((File)patch.getOldFileName()).length();
            newCount = SVNFileUtil.getFilePath((File)patch.getNewFileName()).length();
        }
        return oldCount < newCount ? patch.getOldFileName() : patch.getNewFileName();
    }

    private void putPropTarget(String propName, SvnPropertiesPatchTarget propTarget) {
        this.propTargets.put(propName, propTarget);
    }

    private static File createTempFile(File workingCopyDirectory, SVNWCContext context) throws SVNException {
        return SVNFileUtil.createUniqueFile((File)context.getDb().getWCRootTempDir(workingCopyDirectory), (String)"", (String)"", (boolean)true);
    }

    public void installPatchedTarget(File workingCopyDirectory, boolean dryRun, SVNWCContext context) throws SVNException {
        if (this.isDeleted()) {
            if (!dryRun) {
                SvnNgRemove.delete((SVNWCContext)context, (File)this.getAbsPath(), null, (boolean)false, (boolean)false, null);
            }
        } else {
            if (this.isAdded() || this.isReplaced()) {
                File parentAbsPath = SVNFileUtil.getParentFile((File)this.getAbsPath());
                SVNNodeKind parentDbKind = context.readKind(parentAbsPath, false);
                if (parentDbKind == SVNNodeKind.DIR || parentDbKind == SVNNodeKind.FILE) {
                    if (parentDbKind != SVNNodeKind.DIR) {
                        this.setSkipped(true);
                    } else if (SVNFileType.getType((File)parentAbsPath) != SVNFileType.DIRECTORY) {
                        this.setSkipped(true);
                    }
                } else {
                    this.createMissingParents(workingCopyDirectory, context, dryRun);
                }
            } else {
                SVNNodeKind wcKind = context.readKind(this.getAbsPath(), false);
                if (this.getKindOnDisk() == SVNNodeKind.NONE || wcKind != this.getKindOnDisk()) {
                    this.setSkipped(true);
                }
            }
            if (!dryRun && !this.isSkipped()) {
                if (this.isSpecial()) {
                    String linkName = SVNFileUtil.readFile((File)this.getPatchedAbsPath());
                    if (linkName.startsWith("link ")) {
                        linkName = linkName.substring("link ".length());
                    }
                    if (linkName.endsWith("\n")) {
                        linkName = linkName.substring(0, linkName.length() - "\n".length());
                    }
                    if (linkName.endsWith("\r")) {
                        linkName = linkName.substring(0, linkName.length() - "\r".length());
                    }
                    SVNFileUtil.createSymlink((File)this.getAbsPath(), (String)linkName);
                } else {
                    File dst;
                    File file = dst = this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : this.getAbsPath();
                    if (SVNFileType.getType((File)this.getPatchedAbsPath()) == SVNFileType.SYMLINK) {
                        SVNFileUtil.deleteFile((File)dst);
                        SVNFileUtil.copySymlink((File)this.getPatchedAbsPath(), (File)dst);
                    } else {
                        boolean repairEol = this.getEolStyle() == SVNWCContext.SVNEolStyle.Fixed || this.getEolStyle() == SVNWCContext.SVNEolStyle.Native;
                        SVNTranslator.translate((File)this.getPatchedAbsPath(), (File)dst, null, (byte[])(this.getEolStr() == null ? null : this.getEolStr().getBytes()), (Map)this.getKeywords(), (boolean)false, (boolean)true);
                    }
                }
                if (this.isAdded() || this.isReplaced()) {
                    SvnNgAdd add = new SvnNgAdd();
                    add.setWcContext(context);
                    add.addFromDisk(this.getAbsPath(), null, false);
                }
                SVNFileUtil.setExecutable((File)(this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : this.getAbsPath()), (boolean)this.isExecutable());
                if (this.getMoveTargetAbsPath() != null) {
                    SvnNgWcToWcCopy svnNgWcToWcCopy = new SvnNgWcToWcCopy();
                    svnNgWcToWcCopy.setWcContext(context);
                    svnNgWcToWcCopy.move(context, this.getAbsPath(), this.getMoveTargetAbsPath(), true);
                    SVNFileUtil.deleteFile((File)this.getAbsPath());
                }
            }
        }
    }

    private void createMissingParents(File workingCopyDirectory, SVNWCContext context, boolean dryRun) throws SVNException {
        File localAbsPath = workingCopyDirectory;
        File relPath = this.getRelPath();
        String relPathString = SVNFileUtil.getFilePath((File)relPath);
        String[] components = relPathString.split("/");
        int presentComponents = 0;
        for (String component : components) {
            localAbsPath = SVNFileUtil.createFilePath((File)localAbsPath, (String)component);
            SVNNodeKind wcKind = context.readKind(localAbsPath, true);
            SVNNodeKind diskKind = SVNFileType.getNodeKind((SVNFileType)SVNFileType.getType((File)localAbsPath));
            if (diskKind == SVNNodeKind.FILE || wcKind == SVNNodeKind.FILE) {
                this.setSkipped(true);
                break;
            }
            if (diskKind == SVNNodeKind.DIR) {
                if (wcKind == SVNNodeKind.DIR) {
                    ++presentComponents;
                    continue;
                }
                this.setSkipped(true);
                break;
            }
            if (wcKind == SVNNodeKind.NONE) break;
            this.setSkipped(true);
            break;
        }
        if (!this.isSkipped()) {
            int i;
            localAbsPath = workingCopyDirectory;
            for (i = 0; i < presentComponents; ++i) {
                String component = components[i];
                localAbsPath = SVNFileUtil.createFilePath((File)localAbsPath, (String)component);
            }
            if (!dryRun && presentComponents < components.length - 1) {
                SVNFileUtil.ensureDirectoryExists((File)SVNFileUtil.createFilePath((File)workingCopyDirectory, (File)SVNFileUtil.getFileDir((File)this.getRelPath())));
            }
            for (i = presentComponents; i < components.length - 1; ++i) {
                String component = components[i];
                localAbsPath = SVNFileUtil.createFilePath((File)localAbsPath, (String)component);
                if (dryRun) {
                    ISVNEventHandler eventHandler = context.getEventHandler();
                    if (eventHandler == null) continue;
                    SVNEvent event = SVNEventFactory.createSVNEvent((File)localAbsPath, (SVNNodeKind)SVNNodeKind.DIR, null, (long)-1L, (SVNEventAction)SVNEventAction.ADD, (SVNEventAction)SVNEventAction.ADD, null, null);
                    eventHandler.handleEvent(event, -1.0);
                    continue;
                }
                ISVNEventHandler canceller = context.getEventHandler();
                if (canceller != null) {
                    canceller.checkCancelled();
                }
                SvnNgAdd add = new SvnNgAdd();
                add.setWcContext(context);
                add.addFromDisk(localAbsPath, null, true);
            }
        }
    }

    public void installPatchedPropTarget(boolean dryRun, SVNWCContext context) throws SVNException {
        Map<String, SvnPropertiesPatchTarget> propTargets = this.getPropTargets();
        for (Map.Entry<String, SvnPropertiesPatchTarget> entry : propTargets.entrySet()) {
            SvnPropertiesPatchTarget propTarget = entry.getValue();
            ISVNEventHandler canceller = context.getEventHandler();
            if (canceller != null) {
                canceller.checkCancelled();
            }
            if (propTarget.getOperation() == SvnDiffCallback.OperationKind.Deleted) {
                if (dryRun) continue;
                SvnNgPropertiesManager.setProperty((SVNWCContext)context, (File)this.getAbsPath(), (String)propTarget.getName(), null, (SVNDepth)SVNDepth.EMPTY, (boolean)true, null, null);
                continue;
            }
            if (!this.hasTextChanges() && this.getKindOnDisk() == SVNNodeKind.NONE && !this.isAdded()) {
                if (!dryRun) {
                    SVNFileUtil.createEmptyFile((File)this.getAbsPath());
                    SvnNgAdd add = new SvnNgAdd();
                    add.setWcContext(context);
                    add.addFromDisk(this.getAbsPath(), null, false);
                }
                this.setAdded(true);
            }
            Object propVal = propTarget.getValue() != null && SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propTarget.getValue()).length != 0 && propTarget.getPatchedValue() != null && SVNPropertyValue.getPropertyAsBytes((SVNPropertyValue)propTarget.getPatchedValue()).length == 0 ? null : propTarget.getPatchedValue();
            try {
                if (dryRun) {
                    SVNPropertyValue canonicalPropertyValue = SVNPropertiesManager.validatePropertyValue((Object)this.getAbsPath(), (SVNNodeKind)this.getDbKind(), (String)propTarget.getName(), (SVNPropertyValue)propVal, (boolean)true, null, null);
                    continue;
                }
                SvnNgPropertiesManager.setProperty((SVNWCContext)context, (File)this.getAbsPath(), (String)propTarget.getName(), (SVNPropertyValue)propVal, (SVNDepth)SVNDepth.EMPTY, (boolean)true, null, null);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ILLEGAL_TARGET || e.getErrorMessage().getErrorCode() == SVNErrorCode.NODE_UNEXPECTED_KIND || e.getErrorMessage().getErrorCode() == SVNErrorCode.IO_UNKNOWN_EOL || e.getErrorMessage().getErrorCode() == SVNErrorCode.BAD_MIME_TYPE || e.getErrorMessage().getErrorCode() == SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION) {
                    for (SvnHunkInfo hunkInfo : propTarget.getHunkInfos()) {
                        hunkInfo.setRejected(true);
                        SvnPatchTarget.rejectHunk(this, hunkInfo.getHunk(), propTarget.getName());
                    }
                    continue;
                }
                throw e;
            }
        }
    }

    public void writeOutRejectedHunks(boolean dryRun) throws SVNException {
        try {
            this.getRejectStream().close();
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
            SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
        }
        if (!dryRun && (this.hadRejects() || this.hadPropRejects())) {
            SVNFileUtil.copyFile((File)this.getRejectAbsPath(), (File)SVNFileUtil.createFilePath((String)(SVNFileUtil.getFilePath((File)this.getAbsPath()) + ".svnpatch.rej")), (boolean)false);
        }
    }

    public void sendPatchNotification(SVNWCContext context) throws SVNException {
        ISVNEventHandler eventHandler = context.getEventHandler();
        if (eventHandler == null) {
            return;
        }
        SVNEventAction action = this.isSkipped() ? SVNEventAction.SKIP : (this.isDeleted() ? SVNEventAction.DELETE : (this.isAdded() || this.isReplaced() || this.getMoveTargetAbsPath() != null ? SVNEventAction.ADD : SVNEventAction.PATCH));
        File eventPath = this.getMoveTargetAbsPath() != null ? this.getMoveTargetAbsPath() : (this.getAbsPath() != null ? this.getAbsPath() : this.getRelPath());
        SVNStatusType contentState = SVNStatusType.UNKNOWN;
        SVNStatusType propState = SVNStatusType.UNKNOWN;
        if (action == SVNEventAction.SKIP) {
            contentState = this.getDbKind() == SVNNodeKind.NONE || this.getDbKind() == SVNNodeKind.UNKNOWN ? SVNStatusType.MISSING : (this.getDbKind() == SVNNodeKind.DIR ? SVNStatusType.OBSTRUCTED : SVNStatusType.UNKNOWN);
        } else {
            if (this.hadRejects()) {
                contentState = SVNStatusType.CONFLICTED;
            } else if (this.hasLocalModifications()) {
                contentState = SVNStatusType.MERGED;
            } else if (this.hasTextChanges()) {
                contentState = SVNStatusType.CHANGED;
            }
            if (this.hadPropRejects()) {
                propState = SVNStatusType.CONFLICTED;
            } else if (this.hasPropChanges()) {
                propState = SVNStatusType.CHANGED;
            }
        }
        SVNEvent event = SVNEventFactory.createSVNEvent((File)eventPath, (SVNNodeKind)SVNNodeKind.FILE, null, (long)-1L, (SVNStatusType)contentState, (SVNStatusType)propState, null, (SVNEventAction)action, (SVNEventAction)action, null, null);
        eventHandler.handleEvent(event, -1.0);
        if (action == SVNEventAction.PATCH) {
            for (SvnHunkInfo hunkInfo : this.getHunkInfos()) {
                this.sendHunkNotification(hunkInfo, null, context);
            }
            Map<String, SvnPropertiesPatchTarget> propTargets = this.getPropTargets();
            for (Map.Entry<String, SvnPropertiesPatchTarget> entry : propTargets.entrySet()) {
                SvnPropertiesPatchTarget propTarget = entry.getValue();
                List hunks = propTarget.getHunkInfos();
                for (SvnHunkInfo hunkInfo : hunks) {
                    if (propTarget.getOperation() == SvnDiffCallback.OperationKind.Added || propTarget.getOperation() == SvnDiffCallback.OperationKind.Deleted) continue;
                    this.sendHunkNotification(hunkInfo, propTarget.getName(), context);
                }
            }
        }
        if (this.getMoveTargetAbsPath() != null) {
            event = SVNEventFactory.createSVNEvent((File)this.getAbsPath(), (SVNNodeKind)SVNNodeKind.FILE, null, (long)-1L, (SVNEventAction)SVNEventAction.DELETE, (SVNEventAction)SVNEventAction.DELETE, null, null);
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private void sendHunkNotification(SvnHunkInfo hunkInfo, String propName, SVNWCContext context) throws SVNException {
        SVNEventAction action = hunkInfo.isAlreadyApplied() ? SVNEventAction.PATCH_HUNK_ALREADY_APPLIED : (hunkInfo.isRejected() ? SVNEventAction.PATCH_REJECTED_HUNK : SVNEventAction.PATCH_APPLIED_HUNK);
        SVNEvent event = SVNEventFactory.createSVNEvent((File)(this.getAbsPath() != null ? this.getAbsPath() : this.getRelPath()), (SVNNodeKind)SVNNodeKind.UNKNOWN, null, (long)-1L, (SVNEventAction)action, (SVNEventAction)action, null, null);
        event.setInfo((Object)hunkInfo);
        event.setPropertyName(propName);
        ISVNEventHandler eventHandler = context.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEvent(event, -1.0);
        }
    }

    private boolean hasLocalModifications() {
        return this.hasLocalModifications;
    }

    private boolean hadRejects() {
        return this.hadRejects;
    }

    public void setHadRejects(boolean hadRejects) {
        this.hadRejects = hadRejects;
    }

    private boolean hadPropRejects() {
        return this.hadPropRejects;
    }

    public void setHadPropRejects(boolean hadPropRejects) {
        this.hadPropRejects = hadPropRejects;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    public boolean isSymlink() {
        return this.symlink;
    }

    public void setAdded(boolean added) {
        this.added = added;
    }

    public void setReplaced(boolean replaced) {
        this.replaced = replaced;
    }

    public boolean isLocallyDeleted() {
        return this.locallyDeleted;
    }

    public SVNNodeKind getKindOnDisk() {
        return this.kindOnDisk;
    }

    public SVNNodeKind getDbKind() {
        return this.dbKind;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setDbKind(SVNNodeKind dbKind) {
        this.dbKind = dbKind;
    }

    public void setKindOnDisk(SVNNodeKind kindOnDisk) {
        this.kindOnDisk = kindOnDisk;
    }

    public void setExisted(boolean existed) {
        this.existed = existed;
    }

    public void setCurrentLine(int currentLine) {
        this.currentLine = currentLine;
    }

    public void setHasLocalModifications(boolean hasLocalModifications) {
        this.hasLocalModifications = hasLocalModifications;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public void setAbsPath(File absPath) {
        this.absPath = absPath;
    }

    public void setRelPath(File relPath) {
        this.relPath = relPath;
    }

    public File getCanonPathFromPatchfile() {
        return this.canonPathFromPatchfile;
    }

    public void setCanonPathFromPatchfile(File canonPathFromPatchfile) {
        this.canonPathFromPatchfile = canonPathFromPatchfile;
    }

    public File getRelPath() {
        return this.relPath;
    }

    public void setLocallyDeleted(boolean locallyDeleted) {
        this.locallyDeleted = locallyDeleted;
    }

    public void setSymlink(boolean symlink) {
        this.symlink = symlink;
    }

    public boolean isExisted() {
        return this.existed;
    }

    public int getCurrentLine() {
        return this.currentLine;
    }

    public void setEolStr(String eolStr) {
        this.eolStr = eolStr;
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public File getPatchedAbsPath() {
        return this.patchedAbsPath;
    }

    public void setPatchedAbsPath(File patchedAbsPath) {
        this.patchedAbsPath = patchedAbsPath;
    }

    public void setHasPropChanges(boolean hasPropChanges) {
        this.hasPropChanges = hasPropChanges;
    }

    public void setHasTextChanges(boolean hasTextChanges) {
        this.hasTextChanges = hasTextChanges;
    }

    public void setStream(SVNPatchFileStream stream) {
        this.stream = stream;
    }

    private static class RegularCallbacks
    implements SvnTargetContent.IRealLineCallback,
    SvnTargetContent.ISeekCallback,
    SvnTargetContent.ITellCallback {
        private RegularCallbacks() {
        }

        public String readLine(Object baton, String[] eolStr, boolean[] eof) throws SVNException {
            try {
                SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
                StringBuffer lineBuffer = new StringBuffer();
                StringBuffer eolStrBuffer = new StringBuffer();
                boolean isEof = inputStream.readLineWithEol(lineBuffer, eolStrBuffer);
                if (eof != null) {
                    eof[0] = isEof;
                }
                if (eolStr != null) {
                    eolStr[0] = eolStrBuffer.length() == 0 ? null : eolStrBuffer.toString();
                }
                return lineBuffer.toString();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
                return null;
            }
        }

        public void seek(Object baton, long offset) throws SVNException {
            SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
            try {
                inputStream.setSeekPosition(offset);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
            }
        }

        public long tell(Object baton) throws SVNException {
            SVNPatchFileStream inputStream = (SVNPatchFileStream)baton;
            try {
                return inputStream.getSeekPosition();
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
                return -1L;
            }
        }
    }

    private static class SymlinkReadBaton {
        private final File absPath;
        private boolean atEof;

        public SymlinkReadBaton(File absPath) {
            this.absPath = absPath;
        }

        private File getAbsPath() {
            return this.absPath;
        }

        private boolean isAtEof() {
            return this.atEof;
        }
    }

    private static class SymlinkCallbacks
    implements SvnTargetContent.IWriteCallback,
    SvnTargetContent.IRealLineCallback,
    SvnTargetContent.ISeekCallback,
    SvnTargetContent.ITellCallback {
        private File workingCopyDirectory;
        private SVNWCContext context;

        public SymlinkCallbacks(File workingCopyDirectory, SVNWCContext context) {
            this.workingCopyDirectory = workingCopyDirectory;
            this.context = context;
        }

        public void write(Object writeBaton, String s) throws SVNException {
            if (!s.startsWith("link ")) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_WRITE_ERROR, (String)"Invalid link representation");
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
            }
            s = s.substring("link ".length());
            File targetAbsPath = (File)writeBaton;
            if (SVNFileType.getType((File)targetAbsPath) == SVNFileType.FILE) {
                SVNFileUtil.deleteFile((File)targetAbsPath);
            }
            SVNFileUtil.createSymlink((File)targetAbsPath, (String)s);
        }

        public String readLine(Object baton, String[] eolStr, boolean[] eof) throws SVNException {
            SymlinkReadBaton symlinkReadBaton;
            if (eof != null) {
                eof[0] = true;
            }
            if (eolStr != null) {
                eolStr[0] = null;
            }
            if ((symlinkReadBaton = (SymlinkReadBaton)baton).isAtEof()) {
                return null;
            }
            String symlinkName = SVNFileUtil.getSymlinkName((File)symlinkReadBaton.getAbsPath());
            String symlinkContent = "link " + symlinkName;
            return symlinkContent;
        }

        public void seek(Object readBaton, long offset) {
            SymlinkReadBaton symlinkReadBaton = (SymlinkReadBaton)readBaton;
            symlinkReadBaton.atEof = offset != 0L;
        }

        public long tell(Object readBaton) {
            SymlinkReadBaton symlinkReadBaton = (SymlinkReadBaton)readBaton;
            return symlinkReadBaton.isAtEof() ? 1L : 0L;
        }
    }

    private static class RegularWriteCallback
    implements SvnTargetContent.IWriteCallback {
        private RegularWriteCallback() {
        }

        public void write(Object writeBaton, String s) throws SVNException {
            SVNPatchFileStream outputStream = (SVNPatchFileStream)writeBaton;
            try {
                outputStream.write(s);
            }
            catch (IOException e) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.IO_ERROR, (Throwable)e);
                SVNErrorManager.error((SVNErrorMessage)errorMessage, (SVNLogType)SVNLogType.WC);
            }
        }
    }
}

