/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.rt;

import at.borkowski.spicej.impl.RealTimeTickSource;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.ticks.TickListener;
import java.text.DecimalFormat;
import java.util.Arrays;

public class RealTimeTickSourceTests {
    public static final double EPSILON = 0.03;
    public static final int RETRIES = 20;
    public static final long MS = 1000000L;
    public static final int BUFFER_CAPACITY = 20000000;
    private static int tickCount;
    private static int deltaCount;
    private static long minBound;
    private static Long out_min;
    private static Long minReliable;
    private static int reliability;
    private static int sequence;
    private static boolean finished;
    private static long[] buffer;
    private static long[] deltas;

    public static void main(String[] args) {
        RealTimeTickSourceTests.run();
    }

    private static void settle() {
        long deadline = System.currentTimeMillis() + 30L;
        while (System.currentTimeMillis() < deadline) {
        }
        SleepWakeup.sleep((int)100);
    }

    public static void run() {
        RealTimeTickSourceTests.performMinimumIntervalMeasurement();
        for (int scale = 1; scale < 10; ++scale) {
            RealTimeTickSourceTests.testScale(scale);
        }
        if (minReliable != null) {
            if (reliability > 3) {
                System.out.println("Lowest reliably generateable interval is " + minReliable + " ns");
            } else {
                System.out.println("Lowest reliably generateable interval is " + minReliable + " ns, but not enough consecutive measurements have been found (only " + reliability + ")");
            }
        } else {
            System.out.println("No reliable measurement was possible");
        }
    }

    private static void performMinimumIntervalMeasurement() {
        System.out.println("Measuring minimum interval...");
        Long min = null;
        for (int i = 0; i < 5; ++i) {
            RealTimeTickSourceTests.performAndEvaluateMeasurement("[pre-test]", 20000000, 1.0);
            if (out_min == null || min != null && min <= out_min) continue;
            min = out_min;
        }
        if (min == null) {
            System.out.println("Could not evaluate minium interval (no valid measurements)");
        } else {
            minBound = Math.min(500L, min * 3L / 4L);
            System.out.println("Minmal interval: " + min + " ns, selecting " + minBound + " ns");
        }
    }

    private static void testScale(int scale) {
        double base = Math.pow(10.0, scale);
        System.out.println("scale: 10E" + scale + " ns (" + RealTimeTickSourceTests.format(base / 1000000.0) + " ms)");
        if (base < 1.0E7) {
            RealTimeTickSourceTests.performSeries(base * 1.0);
            RealTimeTickSourceTests.performSeries(base * 2.0);
            RealTimeTickSourceTests.performSeries(base * 3.0);
            RealTimeTickSourceTests.performSeries(base * 4.0);
            RealTimeTickSourceTests.performSeries(base * 5.0);
            RealTimeTickSourceTests.performSeries(base * 6.0);
            RealTimeTickSourceTests.performSeries(base * 7.0);
            RealTimeTickSourceTests.performSeries(base * 8.0);
            RealTimeTickSourceTests.performSeries(base * 9.0);
        } else if (base < 1.0E9) {
            RealTimeTickSourceTests.performSeries(base * 1.0);
            RealTimeTickSourceTests.performSeries(base * 2.0);
            RealTimeTickSourceTests.performSeries(base * 3.0);
            RealTimeTickSourceTests.performSeries(base * 4.0);
            RealTimeTickSourceTests.performSeries(base * 5.0);
            RealTimeTickSourceTests.performSeries(base * 8.0);
        } else {
            RealTimeTickSourceTests.performSeries(base * 1.0);
            RealTimeTickSourceTests.performSeries(base * 3.0);
            RealTimeTickSourceTests.performSeries(base * 5.0);
            RealTimeTickSourceTests.performSeries(base * 9.0);
        }
    }

    private static synchronized void performSeries(double nanoSeconds) {
        if (nanoSeconds < (double)minBound) {
            return;
        }
        boolean ok = false;
        for (int i = 0; i < 20 && !(ok = RealTimeTickSourceTests.performAndEvaluateMeasurement(i > 0 ? "[retry]" : "", RealTimeTickSourceTests.calculateTickCount(nanoSeconds, i), nanoSeconds)); ++i) {
        }
        if (!ok) {
            minReliable = null;
        } else if (minReliable == null) {
            minReliable = (long)nanoSeconds;
        }
        reliability = minReliable != null ? ++reliability : 0;
        if (!ok) {
            RealTimeTickSourceTests.printLabel("[fail]", true);
        }
    }

    private static int calculateTickCount(double nanoSeconds, int retry) {
        int waitForTickCount_ = nanoSeconds < 1000.0 ? 100000 : (nanoSeconds < 10000.0 ? 1000 : (nanoSeconds < 1000000.0 ? 100 : 1));
        return Math.min(buffer.length, (waitForTickCount_ *= 1 + retry * 10) + 1);
    }

    private static synchronized boolean performAndEvaluateMeasurement(String label, int targetTickCount, double nanoSeconds) {
        long nanoSeconds_ = (long)nanoSeconds;
        RealTimeTickSourceTests.settle();
        RealTimeTickSourceTests.performMeasurement(nanoSeconds_, targetTickCount);
        RealTimeTickSourceTests.printLabel(label, false);
        boolean ok = false;
        RealTimeTickSourceTests.msns(nanoSeconds_);
        System.out.printf(" n %8d ", tickCount);
        if (deltaCount == 0) {
            System.out.print("no measured deltas");
        } else {
            Arrays.sort(deltas, 0, deltaCount);
            double average = RealTimeTickSourceTests.average();
            boolean ticksOk = tickCount == targetTickCount;
            boolean ticksAlright = tickCount >= targetTickCount * 95 / 100;
            System.out.printf("avg %13.2f ns ", average);
            double error = average / nanoSeconds - 1.0;
            boolean epsilonOk = Math.abs(error) <= 0.03;
            System.out.printf("err %8.2f %% (", error * 100.0);
            RealTimeTickSourceTests.msns((long)(average - nanoSeconds));
            System.out.printf(") ", new Object[0]);
            if (!ticksOk) {
                System.out.print("(INCOMPLETE MEASUREMENT " + RealTimeTickSourceTests.format(100.0 * (double)tickCount / (double)targetTickCount) + " %) ");
            }
            if (!epsilonOk) {
                System.out.print("(ERROR TOO HIGH, > " + RealTimeTickSourceTests.format(3.0) + " %) ");
            }
            ok = ticksAlright && epsilonOk;
        }
        System.out.println();
        return ok;
    }

    private static void msns(long nanoSeconds) {
        if (Math.abs(nanoSeconds) < 10000L) {
            System.out.printf("%7d ns", nanoSeconds);
        } else {
            System.out.printf("%7.2f ms", (double)nanoSeconds / 1000000.0);
        }
    }

    private static void printLabel(String label, boolean newline) {
        System.out.printf("%11s ", label);
        if (newline) {
            System.out.println();
        }
    }

    private static void performMeasurement(long nanoSeconds_, final int targetTickCount) {
        int i;
        RealTimeTickSource sut = new RealTimeTickSource(nanoSeconds_, false);
        tickCount = 0;
        finished = false;
        for (i = 0; i < buffer.length; ++i) {
            RealTimeTickSourceTests.buffer[i] = 0L;
        }
        for (i = 0; i < deltas.length; ++i) {
            RealTimeTickSourceTests.buffer[i] = 0L;
        }
        final int currentSequence = ++sequence;
        TickListener listener = new TickListener(){

            public void tick(long tick) {
                long time = System.nanoTime();
                if (finished) {
                    return;
                }
                if (sequence != currentSequence) {
                    return;
                }
                buffer[tickCount++] = time;
                finished = tickCount >= targetTickCount;
            }
        };
        sut.addListener(listener);
        long netDurationMs = (long)((double)targetTickCount / 1000000.0 * (double)nanoSeconds_);
        long deadline = System.currentTimeMillis() + Math.max(1000L, netDurationMs * 4L);
        sut.start();
        while (!finished && System.currentTimeMillis() < deadline) {
            SleepWakeup.sleep((int)1);
        }
        sut.removeListener(listener);
        sut.stop();
        finished = true;
        deltaCount = 0;
        long lastValidTimestamp = 0L;
        for (int i2 = 0; i2 < targetTickCount; ++i2) {
            if (lastValidTimestamp != 0L && buffer[i2] != 0L) {
                RealTimeTickSourceTests.deltas[RealTimeTickSourceTests.deltaCount++] = buffer[i2] - lastValidTimestamp;
            }
            if (buffer[i2] == 0L) continue;
            lastValidTimestamp = buffer[i2];
        }
    }

    private static double average() {
        out_min = null;
        double sum = 0.0;
        for (int i = 0; i < deltaCount; ++i) {
            out_min = out_min != null ? Long.valueOf(Math.min(out_min, deltas[i])) : Long.valueOf(deltas[i]);
            sum += (double)deltas[i];
        }
        return sum / (double)deltaCount;
    }

    private static String format(double d) {
        return new DecimalFormat("0.00").format(d);
    }

    static {
        minBound = 0L;
        out_min = null;
        minReliable = null;
        reliability = 0;
        sequence = 0;
        buffer = new long[20000000];
        deltas = new long[20000000];
    }
}

