/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.rt;

import at.borkowski.spicej.Streams;
import at.borkowski.spicej.impl.RealTimeTickSource;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.proxy.DelayCalculator;
import at.borkowski.spicej.streams.DelayedInputStream;
import at.borkowski.spicej.streams.util.PipedInputStream;
import at.borkowski.spicej.streams.util.PipedOutputStream;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.junit.Assert;

public class DelayInputStreamTests {
    private static final int BUFFER = 102400;
    static byte[][] blocks = new byte[][]{new byte[10], new byte[504], new byte[314], new byte[271], new byte[1337]};
    static byte[][] read = new byte[blocks.length][];
    static boolean allRead;
    static Random random;
    static long[] timestamps_0;
    static long[] timestamps_1;

    public static void main(String[] args) throws IOException {
        DelayInputStreamTests.run();
    }

    public static void run() throws IOException {
        for (int scale = 1; scale < 91; ++scale) {
            DelayInputStreamTests.testScale(scale);
        }
    }

    private static void testScale(int scale) throws IOException {
        long base = (long)Math.pow(10.0, scale);
        System.out.print("scale: 10E" + scale + " ns (");
        DelayInputStreamTests.format(base);
        System.out.println(")");
        DelayInputStreamTests.performMeasurement(base * 1L);
        DelayInputStreamTests.performMeasurement(base * 2L);
        DelayInputStreamTests.performMeasurement(base * 3L);
        DelayInputStreamTests.performMeasurement(base * 4L);
        DelayInputStreamTests.performMeasurement(base * 5L);
        DelayInputStreamTests.performMeasurement(base * 6L);
        DelayInputStreamTests.performMeasurement(base * 7L);
        DelayInputStreamTests.performMeasurement(base * 8L);
        DelayInputStreamTests.performMeasurement(base * 9L);
    }

    private static void performMeasurement(long nanoseconds) throws IOException {
        PipedInputStream pis = new PipedInputStream();
        try (PipedOutputStream pos = new PipedOutputStream(pis);){
            DelayCalculator.Result result = DelayCalculator.calculate((long)nanoseconds);
            RealTimeTickSource t = new RealTimeTickSource(result.getTickNanosecondsInterval());
            final DelayedInputStream dis = Streams.addDelay((InputStream)pis, (TickSource)t, (long)result.getDelay(), (int)102400);
            Thread reader = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < blocks.length; ++i) {
                            int rd;
                            DelayInputStreamTests.read[i] = new byte[blocks[i].length];
                            for (int done = 0; done < blocks[i].length; done += rd) {
                                allRead = false;
                                rd = dis.read(read[i], done, blocks[i].length - done);
                            }
                            DelayInputStreamTests.timestamps_1[i] = System.nanoTime();
                        }
                        allRead = true;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            long sleepNs = nanoseconds * 2L / 3L;
            long sleepMs = sleepNs / 1000000L;
            int sleepNsInt = (int)(sleepNs % 1000000L);
            allRead = true;
            reader.start();
            while (allRead) {
                SleepWakeup.sleep((int)10);
            }
            for (int i = 0; i < blocks.length; ++i) {
                pos.write(blocks[i]);
                DelayInputStreamTests.timestamps_0[i] = System.nanoTime();
                try {
                    Thread.sleep(sleepMs, sleepNsInt);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
            while (!allRead) {
                SleepWakeup.sleep((int)10);
            }
            t.stop();
            long sum = 0L;
            for (int i = 0; i < blocks.length; ++i) {
                sum += timestamps_1[i] - timestamps_0[i];
                Assert.assertArrayEquals((byte[])blocks[i], (byte[])read[i]);
            }
            long interval = sum / (long)blocks.length;
            double error = ((double)interval / (double)nanoseconds - 1.0) * 100.0;
            System.out.printf("delay ", new Object[0]);
            DelayInputStreamTests.format(nanoseconds);
            System.out.printf(" avg ", new Object[0]);
            DelayInputStreamTests.format(interval);
            System.out.printf(" err %6.2f %%", error);
            System.out.println();
        }
    }

    private static void format(long nanoseconds) {
        if (nanoseconds < 1000000L) {
            System.out.printf("%8.0f ns", nanoseconds);
        } else if (nanoseconds < 1000000000L) {
            System.out.printf("%8.2f ms", (double)nanoseconds / 1000000.0);
        } else {
            System.out.printf("%8.2f  s", (double)nanoseconds / 1.0E9);
        }
    }

    static {
        random = new Random();
        timestamps_0 = new long[blocks.length];
        timestamps_1 = new long[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            random.nextBytes(blocks[i]);
        }
    }
}

