/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.rt;

import at.borkowski.spicej.Streams;
import at.borkowski.spicej.bytes.RateLimitInputStream;
import at.borkowski.spicej.impl.RealTimeTickSource;
import at.borkowski.spicej.proxy.RateCalculator;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

public class RateLimitInputStreamTests {
    public static final int MAX_BYTES = 10000;
    private static int sequence = 0;

    public static void main(String[] args) throws IOException {
        RateLimitInputStreamTests.run();
    }

    public static void run() throws IOException {
        for (int scale = 1; scale < 10; ++scale) {
            RateLimitInputStreamTests.testScale(scale);
        }
    }

    private static void testScale(int scale) throws IOException {
        double base = Math.pow(10.0, scale);
        System.out.print("scale: 10E" + scale + " b/s (");
        RateLimitInputStreamTests.format(base);
        System.out.println(")");
        RateLimitInputStreamTests.performMeasurement(base * 1.0);
        RateLimitInputStreamTests.performMeasurement(base * 2.0);
        RateLimitInputStreamTests.performMeasurement(base * 3.0);
        RateLimitInputStreamTests.performMeasurement(base * 4.0);
        RateLimitInputStreamTests.performMeasurement(base * 5.0);
        RateLimitInputStreamTests.performMeasurement(base * 6.0);
        RateLimitInputStreamTests.performMeasurement(base * 7.0);
        RateLimitInputStreamTests.performMeasurement(base * 8.0);
        RateLimitInputStreamTests.performMeasurement(base * 9.0);
    }

    private static void performMeasurement(double bytesPerSecond) throws IOException {
        long bytes = RateLimitInputStreamTests.calculateBytes(bytesPerSecond);
        final byte[] devzero = new byte[(int)Math.min(bytes, 10000L)];
        byte[] devnull = new byte[(int)Math.min(bytesPerSecond, 10000.0)];
        PipedInputStream pis = new PipedInputStream(devzero.length * 5);
        try (final PipedOutputStream pos = new PipedOutputStream(pis);){
            long done;
            int rd;
            RateCalculator.Result result = RateCalculator.calculate((float)((float)bytesPerSecond), (int)1000000);
            RealTimeTickSource t = new RealTimeTickSource((long)result.getTickNanosecondInterval(), true);
            RateLimitInputStream sut = Streams.limitRate((InputStream)pis, (TickSource)t, (int)result.getBytesPerTick(), (int)result.getPrescale());
            final int currentSequence = ++sequence;
            Thread stuffer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (sequence == currentSequence) {
                            pos.write(devzero);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            stuffer.start();
            long t0 = System.currentTimeMillis();
            for (done = 0L; done < bytes; done += (long)rd) {
                rd = sut.read(devnull);
                if (rd != -1) continue;
                throw new Error("read -1");
            }
            long t1 = System.currentTimeMillis();
            ++sequence;
            sut.close();
            long tt = t1 - t0;
            double rate = 1000.0 * (double)done / (double)tt;
            System.out.printf("rate %16.2f B/s ", bytesPerSecond);
            System.out.printf("read %12d in %5d ", done, tt);
            System.out.printf("eff ", new Object[0]);
            RateLimitInputStreamTests.format(rate);
            System.out.printf(" error %5.2f %% ", 100.0 * rate / bytesPerSecond - 100.0);
            System.out.println();
        }
    }

    private static long calculateBytes(double bytesPerSecond) {
        return (long)((double)RateLimitInputStreamTests.calculateTargetTime(bytesPerSecond) * bytesPerSecond / 1000.0);
    }

    private static int calculateTargetTime(double bytesPerSecond) {
        if (bytesPerSecond < 50.0) {
            return 5000;
        }
        if (bytesPerSecond < 500.0) {
            return 2000;
        }
        return 500;
    }

    private static void format(double bytesPerSecond) {
        if (bytesPerSecond < 1100.0) {
            System.out.printf("%5.0f B/s", bytesPerSecond);
        } else if (bytesPerSecond < 1100000.0) {
            System.out.printf("%5.2f kB/s", bytesPerSecond / 1000.0);
        } else {
            System.out.printf("%5.2f MB/s", bytesPerSecond / 1000000.0);
        }
    }
}

