/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.proxy;

import at.borkowski.spicej.Streams;
import at.borkowski.spicej.proxy.StreamGobbler;
import at.borkowski.spicej.rt.DelayCalculator;
import at.borkowski.spicej.rt.RateCalculator;
import at.borkowski.spicej.rt.RealTimeTickSource;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class SocketProxy
implements Runnable {
    final int localPort;
    final int remotePort;
    final String remoteHost;
    final Float rateUp;
    final Float rateDown;
    final Float delayUp;
    final Float delayDown;
    private ServerSocket listener;
    public static final int BUFFER_SIZE = 102400;

    public SocketProxy(int localPort, String remoteHost, int remotePort, Float rateUp, Float rateDown, Float delayUp, Float delayDown) {
        this.localPort = localPort;
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
        this.rateUp = rateUp;
        this.rateDown = rateDown;
        this.delayUp = delayUp;
        this.delayDown = delayDown;
    }

    private static InputStream delay(InputStream inputStream, Float delay) {
        if (delay == null || delay.floatValue() * 1000000.0f < 1.0f) {
            return inputStream;
        }
        DelayCalculator.Result calculation = DelayCalculator.calculate((long)((long)(1000000.0 * (double)delay.floatValue())));
        return Streams.addDelay((InputStream)inputStream, (TickSource)new RealTimeTickSource(calculation.getTickNanosecondsInterval(), true), (long)calculation.getDelay(), (int)102400);
    }

    private static InputStream rate(InputStream inputStream, Float rate) {
        if (rate == null) {
            return inputStream;
        }
        RateCalculator.Result calculation = RateCalculator.calculate((float)rate.floatValue());
        return Streams.limitRate((InputStream)inputStream, (TickSource)new RealTimeTickSource((long)calculation.getTickNanosecondsInterval(), true), (int)calculation.getBytesPerTick(), (int)calculation.getPrescale());
    }

    public void initialize() throws IOException {
        if (this.listener != null) {
            throw new IllegalStateException("already initialized");
        }
        this.listener = new ServerSocket(this.localPort);
    }

    @Override
    public void run() {
        block6: while (true) {
            try {
                while (true) {
                    Socket client = this.listener.accept();
                    try {
                        Socket server = new Socket(this.remoteHost, this.remotePort);
                        Thread connector = new Thread(new Connector(client, server));
                        connector.setDaemon(true);
                        connector.start();
                        continue block6;
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                        try {
                            client.close();
                            continue block6;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    class Connector
    implements Runnable {
        private final Socket client;
        private final Socket server;

        public Connector(Socket client, Socket server) {
            this.client = client;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StreamGobbler a = null;
            StreamGobbler b = null;
            try {
                a = new StreamGobbler(SocketProxy.delay(SocketProxy.rate(this.client.getInputStream(), SocketProxy.this.rateUp), SocketProxy.this.delayUp), this.server.getOutputStream());
                b = new StreamGobbler(SocketProxy.delay(SocketProxy.rate(this.server.getInputStream(), SocketProxy.this.rateDown), SocketProxy.this.delayDown), this.client.getOutputStream());
                Thread t = new Thread(a);
                t.setDaemon(true);
                t.start();
                t = new Thread(b);
                t.setDaemon(true);
                t.start();
                a.waitFor();
                b.waitFor();
            }
            catch (SocketException ignore) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                a.close();
                b.close();
                try {
                    this.client.close();
                }
                catch (Exception ignore) {}
                try {
                    this.server.close();
                }
                catch (Exception ignore) {}
            }
        }
    }
}

