/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.proxy;

import at.borkowski.spicej.proxy.CommandLine;
import at.borkowski.spicej.proxy.SocketProxy;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.IOException;

public class ProxyMain {
    private static boolean printUsage = true;
    private static boolean printCommandLineErrors = true;

    public static void main(String[] args) throws IOException {
        SocketProxy proxy = ProxyMain.processCommand(args);
        if (proxy != null) {
            try {
                proxy.initialize();
            }
            catch (IOException e) {
                System.err.println("Error in set-up: " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
                return;
            }
            proxy.run();
        }
    }

    public static SocketProxy processCommand(String ... args) {
        CommandLine commandLine = new CommandLine();
        JCommander commander = new JCommander((Object)commandLine);
        try {
            commander.parse(args);
        }
        catch (ParameterException pEx) {
            ProxyMain.err(pEx.getMessage());
            ProxyMain.usage(commander);
            return null;
        }
        if (commandLine.help) {
            ProxyMain.usage(commander);
            return null;
        }
        if (commandLine.udp) {
            ProxyMain.err("UDP is not yet implemented");
            return null;
        }
        if (commandLine.rate != null) {
            if (commandLine.rateReceive != null) {
                ProxyMain.err("You can't use --rate and --rate-receive at the same time");
                return null;
            }
            if (commandLine.rateSend != null) {
                ProxyMain.err("You can't use --rate and --rate-send at the same time");
                return null;
            }
            commandLine.rateReceive = commandLine.rateSend = commandLine.rate;
        }
        if (commandLine.delay != null) {
            if (commandLine.delayReceive != null) {
                ProxyMain.err("You can't use --delay and --delay-receive at the same time");
                return null;
            }
            if (commandLine.delaySend != null) {
                ProxyMain.err("You can't use --delay and --delay-send at the same time");
                return null;
            }
            commandLine.delayReceive = commandLine.delaySend = commandLine.delay;
        }
        if (commandLine.proxyDescription.size() != 1) {
            ProxyMain.err("Exactly one proxy description required in the form of localPort:[remoteHost:]remotePort");
            return null;
        }
        String[] split = commandLine.proxyDescription.get(0).split(":");
        if (split.length < 2 || split.length > 3) {
            ProxyMain.err("Proxy description must be in the form of localPort:[remoteHost:]remotePort (is \"" + commandLine.proxyDescription.get(0) + "\"");
            return null;
        }
        String remoteHost = "localhost";
        int localPort = Integer.parseInt(split[0]);
        int remotePort = Integer.parseInt(split[split.length - 1]);
        if (split.length == 3) {
            remoteHost = split[1];
        }
        SocketProxy sp = new SocketProxy(localPort, remoteHost, remotePort, commandLine.rateSend, commandLine.rateReceive, commandLine.delayReceive, commandLine.delaySend);
        return sp;
    }

    private static void err(String string) {
        if (printCommandLineErrors) {
            System.err.println(string);
        }
    }

    private static void usage(JCommander commander) {
        if (printUsage) {
            commander.usage();
        }
    }

    public static void setPrintUsage(boolean printUsage) {
        ProxyMain.printUsage = printUsage;
    }

    public static void setPrintCommandLineErrors(boolean printCommandLineErrors) {
        ProxyMain.printCommandLineErrors = printCommandLineErrors;
    }
}

