/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.shapers.RateShaper;
import at.borkowski.spicej.streams.RateHelper;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;

public class RateLimitInputStream
extends InputStream
implements RateShaper {
    private final InputStream real;
    private final RateHelper rateHelper;
    private boolean boring = false;

    public RateLimitInputStream(InputStream real, TickSource tickSource, int byteRate, int prescale) {
        this.real = real;
        this.rateHelper = new RateHelper(tickSource, byteRate, prescale);
    }

    @Override
    public void setByteRate(int bytesPerTick) {
        this.rateHelper.setThingsPerTick(bytesPerTick);
    }

    @Override
    public int getByteRate() {
        return this.rateHelper.getThingsPerTick();
    }

    private int realRead(byte[] b, int off, int len) throws IOException {
        int lenToRead = this.rateHelper.take(len);
        int rd = this.real.read(b, off, lenToRead);
        if (rd != lenToRead) {
            this.rateHelper.giveBack(lenToRead - rd);
        }
        return rd;
    }

    @Override
    public int read() throws IOException {
        this.rateHelper.takeOne();
        return this.real.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int done;
        for (done = 0; done < len && (done == 0 || this.available() > 0 || this.boring && this.real.available() > 0); done += this.realRead(b, off + done, Math.min(len - done, Math.max(1, this.rateHelper.getThingsPerTick())))) {
        }
        return done;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.real.available(), this.rateHelper.getTimewiseAvailable());
    }

    @Override
    public void close() throws IOException {
        this.real.close();
        this.rateHelper.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.real.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.real.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.real.reset();
    }

    void test__SetIdleNotify(RateHelper.IdleNotify target) {
        this.rateHelper.test__SetIdleNotify(target);
    }

    public void setBoring(boolean boring) {
        this.boring = boring;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.rateHelper.setNonBlocking(nonBlocking);
    }

    public InputStream getBaseStream() {
        return this.real;
    }

    public TickSource getTickSource() {
        return this.rateHelper.getTickSource();
    }

    @Override
    public int getPrescale() {
        return this.rateHelper.getPrescale();
    }

    @Override
    public void setPrescale(int prescale) {
        this.rateHelper.setPrescale(prescale);
    }
}

