/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.WouldBlockException;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.shapers.DelayShaper;
import at.borkowski.spicej.ticks.TickListener;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class DelayedOutputStream
extends OutputStream
implements TickListener,
DelayShaper {
    private final OutputStream real;
    private final TickSource t;
    private long delay;
    private final byte[] buffer;
    private boolean blocking = true;
    private long currentTick;
    private volatile int currentAvailableEnd = 0;
    private volatile int start = 0;
    private volatile int end = 0;
    private SortedSet<Long> tickMarks = new TreeSet<Long>();
    private Map<Long, Integer> tick_virtualEnd = new HashMap<Long, Integer>();
    private SleepWakeup sleep = new SleepWakeup();

    public DelayedOutputStream(TickSource t, OutputStream real, long delay, int bufferSize) {
        this.real = real;
        this.t = t;
        this.delay = delay;
        this.buffer = new byte[bufferSize + 1];
        t.addListener(this);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (this.freeBytes() < len) {
            if (!this.blocking) {
                throw new WouldBlockException();
            }
            this.sleep.sleep();
        }
        if (this.end + len >= this.buffer.length) {
            int chunk1 = this.buffer.length - this.end;
            System.arraycopy(b, off, this.buffer, this.end, chunk1);
            this.end = 0;
            off += chunk1;
            len -= chunk1;
        }
        System.arraycopy(b, off, this.buffer, this.end, len);
        int previousEnd = this.end;
        this.end += len;
        if (this.end >= this.buffer.length) {
            this.end -= this.buffer.length;
        }
        if (this.end != previousEnd && this.delay > 0L) {
            this.tick_virtualEnd.put(this.currentTick + this.delay, this.end);
            this.tickMarks.add(this.currentTick + this.delay);
        }
        if (this.delay == 0L) {
            this.handleWritableData();
        }
    }

    @Override
    public void tick(long tick) {
        this.currentTick = tick;
        this.handleWritableData();
    }

    private void handleWritableData() {
        int writable;
        while (!this.tickMarks.isEmpty() && this.tickMarks.first() <= this.currentTick) {
            Long tick = this.tickMarks.first();
            this.tickMarks.remove(tick);
            this.currentAvailableEnd = this.tick_virtualEnd.remove(tick);
        }
        if (this.tickMarks.isEmpty()) {
            this.currentAvailableEnd = this.end;
        }
        if ((writable = this.bufferedBytes(this.currentAvailableEnd)) == 0) {
            return;
        }
        try {
            int todo = writable;
            if (this.start + todo > this.buffer.length) {
                int chunk1 = this.buffer.length - this.start;
                this.real.write(this.buffer, this.start, chunk1);
                todo -= chunk1;
                this.start = 0;
            }
            this.real.write(this.buffer, this.start, todo);
            this.start += todo;
            if (this.start >= this.buffer.length) {
                this.start -= this.buffer.length;
            }
        }
        catch (IOException ioEx) {
            throw new RuntimeException("delayed data transmission error", ioEx);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.real.close();
    }

    int bufferedBytes() {
        return this.bufferedBytes(this.end);
    }

    int bufferedBytes(int effectiveEnd) {
        if (this.start == effectiveEnd) {
            return 0;
        }
        if (this.start < effectiveEnd) {
            return effectiveEnd - this.start;
        }
        return effectiveEnd - this.start + this.buffer.length;
    }

    int freeBytes() {
        return this.buffer.length - this.bufferedBytes() - 1;
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
        long longestAcceptableDeadline = this.currentTick + delay;
        LinkedList<Long> toDelete = new LinkedList<Long>();
        for (Long tick : this.tickMarks) {
            if (tick <= longestAcceptableDeadline) continue;
            toDelete.add(tick);
        }
        for (Long tick : toDelete) {
            int previousVirtualEnd = this.tick_virtualEnd.get(tick);
            this.tickMarks.remove(tick);
            this.tick_virtualEnd.remove(tick);
            long currentVirtualEnd = -1L;
            if (this.tickMarks.contains(longestAcceptableDeadline)) {
                currentVirtualEnd = this.tick_virtualEnd.get(longestAcceptableDeadline).intValue();
            }
            this.tickMarks.add(longestAcceptableDeadline);
            if (currentVirtualEnd > (long)previousVirtualEnd) continue;
            this.tick_virtualEnd.put(longestAcceptableDeadline, previousVirtualEnd);
        }
        this.handleWritableData();
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    public int getBufferSize() {
        return this.buffer.length - 1;
    }

    public OutputStream getBaseStream() {
        return this.real;
    }

    public TickSource getTickSource() {
        return this.t;
    }
}

