/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.streams;

import at.borkowski.spicej.WouldBlockException;
import at.borkowski.spicej.impl.SleepWakeup;
import at.borkowski.spicej.shapers.DelayShaper;
import at.borkowski.spicej.ticks.TickListener;
import at.borkowski.spicej.ticks.TickSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class DelayedInputStream
extends InputStream
implements TickListener,
DelayShaper,
Runnable {
    private final InputStream real;
    private final TickSource t;
    private long delay;
    private final byte[] buffer;
    private boolean blocking = true;
    private boolean eof = false;
    private boolean closed = false;
    private boolean eofDetection = false;
    private long currentTick;
    private volatile int currentAvailableEnd = 0;
    private volatile int start = 0;
    private volatile int end = 0;
    private SortedSet<Long> tickMarks = new TreeSet<Long>();
    private Map<Long, Integer> tick_virtualEnd = new HashMap<Long, Integer>();
    private SleepWakeup sleepForTick = new SleepWakeup();
    private Thread eofDetector;
    private Object eofDetectorLock = new Object();
    volatile boolean eofDetectorActive = false;
    private volatile boolean eofDetectorReady = false;
    private volatile int eofDetectorResult = -3;
    private volatile Throwable eofDetectorThrowable = null;

    public DelayedInputStream(TickSource t, InputStream real, long delay, int bufferSize) {
        this.real = real;
        this.t = t;
        this.delay = delay;
        this.buffer = new byte[bufferSize + 1];
        t.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureRunningEofDetector() {
        if (this.eofDetectorActive || !this.eofDetection) {
            return;
        }
        Object object = this.eofDetectorLock;
        synchronized (object) {
            if (this.eofDetectorActive) {
                return;
            }
            this.eofDetectorActive = true;
        }
        this.eofDetector = new Thread((Runnable)this, "EOF Detector for " + this);
        this.eofDetector.setDaemon(true);
        this.eofDetector.start();
        while (!this.eofDetectorReady) {
        }
        this.eofDetectorReady = false;
    }

    private int getEofResult() {
        int result = -3;
        if (!this.eofDetectorActive) {
            result = this.eofDetectorResult;
        }
        this.eofDetectorResult = -3;
        return result;
    }

    @Override
    public int read() throws IOException {
        this.checkNotClosed();
        if (this.delay == 0L) {
            this.handleNewData();
        }
        if (this.eof && this.start == this.end) {
            return -1;
        }
        this.waitForAvailable();
        byte b = this.buffer[this.start++];
        if (this.start >= this.buffer.length) {
            this.start -= this.buffer.length;
        }
        return b & 0xFF;
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed by reader");
        }
    }

    private void waitForAvailable() {
        while (this.bufferedBytes(this.currentAvailableEnd) == 0) {
            if (!this.blocking) {
                throw new WouldBlockException();
            }
            this.sleepForTick.sleep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        try {
            object = this.eofDetectorLock;
            synchronized (object) {
                try {
                    int result;
                    this.eofDetectorReady = true;
                    this.eofDetectorResult = result = this.real.read();
                }
                catch (Throwable t) {
                    this.eofDetectorResult = -2;
                    this.eofDetectorThrowable = t;
                }
            }
        }
        finally {
            object = this.eofDetectorLock;
            synchronized (object) {
                this.eofDetectorActive = false;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.real.close();
        this.closed = true;
        this.eof = true;
        this.t.removeListener(this);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if (this.eof && this.start == this.end) {
            return -1;
        }
        this.checkNotClosed();
        if (this.delay == 0L) {
            this.handleNewData();
        }
        this.waitForAvailable();
        int readable = this.bufferedBytes(this.currentAvailableEnd);
        int toRead = ret = Math.min(len, readable);
        if (this.start + toRead > this.buffer.length) {
            int chunk1 = this.buffer.length - this.start;
            System.arraycopy(this.buffer, this.start, b, off, chunk1);
            toRead -= chunk1;
            off += chunk1;
            this.start = 0;
        }
        System.arraycopy(this.buffer, this.start, b, off, toRead);
        this.start += toRead;
        if (this.start >= this.buffer.length) {
            this.start -= this.buffer.length;
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    int bufferedBytes() {
        return this.bufferedBytes(this.end);
    }

    int bufferedBytes(int effectiveEnd) {
        if (this.start == effectiveEnd) {
            return 0;
        }
        if (this.start < effectiveEnd) {
            return effectiveEnd - this.start;
        }
        return effectiveEnd - this.start + this.buffer.length;
    }

    int freeBytes() {
        return this.buffer.length - this.bufferedBytes() - 1;
    }

    @Override
    public void tick(long tick) {
        this.currentTick = tick;
        this.handleNewData();
    }

    @Override
    public int available() throws IOException {
        this.checkNotClosed();
        if (this.eof && this.start == this.end) {
            return 0;
        }
        if (this.delay == 0L) {
            this.handleNewData();
        }
        return this.bufferedBytes(this.currentAvailableEnd);
    }

    private void handleNewData() {
        try {
            int previousEnd = this.end;
            int eofResult = this.getEofResult();
            boolean noFurtherAction = false;
            if (eofResult == -2) {
                throw new RuntimeException(this.eofDetectorThrowable);
            }
            if (eofResult == -1) {
                this.eof = true;
            } else if (eofResult >= 0) {
                if (this.freeBytes() <= 0) {
                    this.eofDetectorResult = eofResult;
                    noFurtherAction = true;
                } else {
                    this.buffer[this.end] = (byte)eofResult;
                    if (++this.end >= this.buffer.length) {
                        this.end -= this.buffer.length;
                    }
                }
            }
            if (!(noFurtherAction || this.eofDetectorActive || this.eof || this.real.available() <= 0 || this.freeBytes() <= 0)) {
                int rd;
                for (int toRead = Math.min(this.freeBytes(), this.real.available()); toRead > 0; toRead -= rd) {
                    rd = this.real.read(this.buffer, this.end, Math.min(toRead, this.buffer.length - this.end));
                    if (rd == -1) {
                        this.eof = true;
                        break;
                    }
                    this.end += rd;
                    if (this.end < this.buffer.length) continue;
                    this.end -= this.buffer.length;
                }
            } else if (!this.eof && this.real.available() == 0 && this.freeBytes() > 0) {
                this.ensureRunningEofDetector();
            }
            if (this.end != previousEnd && this.delay > 0L) {
                this.tick_virtualEnd.put(this.currentTick + this.delay - 1L, this.end);
                this.tickMarks.add(this.currentTick + this.delay - 1L);
            }
            this.sleepForTick.wakeup();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.handleNewTickMarks();
    }

    private void handleNewTickMarks() {
        while (!this.tickMarks.isEmpty() && this.tickMarks.first() <= this.currentTick) {
            Long tick = this.tickMarks.first();
            this.tickMarks.remove(tick);
            this.currentAvailableEnd = this.tick_virtualEnd.remove(tick);
        }
        if (this.tickMarks.isEmpty()) {
            this.currentAvailableEnd = this.end;
        }
    }

    @Override
    public void setDelay(long delay) {
        this.delay = delay;
        long longestAcceptableDeadline = this.currentTick + delay;
        LinkedList<Long> toDelete = new LinkedList<Long>();
        for (Long tick : this.tickMarks) {
            if (tick <= longestAcceptableDeadline) continue;
            toDelete.add(tick);
        }
        for (Long tick : toDelete) {
            int previousVirtualEnd = this.tick_virtualEnd.get(tick);
            this.tickMarks.remove(tick);
            this.tick_virtualEnd.remove(tick);
            long currentVirtualEnd = -1L;
            if (this.tickMarks.contains(longestAcceptableDeadline)) {
                currentVirtualEnd = this.tick_virtualEnd.get(longestAcceptableDeadline).intValue();
            }
            this.tickMarks.add(longestAcceptableDeadline);
            if (currentVirtualEnd > (long)previousVirtualEnd) continue;
            this.tick_virtualEnd.put(longestAcceptableDeadline, previousVirtualEnd);
        }
        this.handleNewTickMarks();
    }

    @Override
    public long getDelay() {
        return this.delay;
    }

    public int getBufferSize() {
        return this.buffer.length - 1;
    }

    public InputStream getBaseStream() {
        return this.real;
    }

    public TickSource getTickSource() {
        return this.t;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.blocking = !nonBlocking;
    }

    void __waitForEofDetector() {
        while (this.eofDetectorActive) {
        }
    }

    public void setEofDetection(boolean eofDetection) {
        this.eofDetection = eofDetection;
    }
}

