/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.rt;

import at.borkowski.spicej.impl.AbstractTickSource;
import at.borkowski.spicej.ticks.TickListener;

public class RealTimeTickSource
extends AbstractTickSource {
    private final long interval;
    private boolean keepAlive = false;
    private MyTimer timer;
    public static final long BUSY_WAITING_THRESHOLD = 10000000L;
    public static final long MILLISECOND_THRESHOLD = 50000000L;

    public RealTimeTickSource(long nanoSecondsPerTick) {
        this(nanoSecondsPerTick, true);
    }

    public RealTimeTickSource(long nanoSecondsPerTick, boolean start) {
        this.interval = nanoSecondsPerTick;
        if (start) {
            this.start();
        }
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public void reset() {
        this.stop();
    }

    @Override
    public void removeListener(TickListener listener) {
        super.removeListener(listener);
        if (this.listeners.isEmpty() && !this.keepAlive) {
            this.stop();
        }
    }

    public void start() {
        if (this.timer != null) {
            throw new IllegalStateException("already running");
        }
        this.timer = this.interval < 10000000L ? new MyBusyTimer() : (this.interval < 50000000L ? new MyWaitingTimer() : new MyMillisecondTimer());
        Thread thread = new Thread((Runnable)this.timer, "timer");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    private class MyMillisecondTimer
    extends MyTimer {
        private final Object lock;

        private MyMillisecondTimer() {
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextWakeup = System.currentTimeMillis();
            while (!this.cancel) {
                long period;
                if (System.currentTimeMillis() >= nextWakeup) {
                    RealTimeTickSource.super.doTick();
                    nextWakeup += RealTimeTickSource.this.interval / 1000000L;
                }
                if ((period = (nextWakeup - System.currentTimeMillis()) / 4L) <= 5L) continue;
                period = Math.min(period, 100L);
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(period);
                    }
                }
                catch (InterruptedException ignore) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void cancel() {
            super.cancel();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    private class MyWaitingTimer
    extends MyTimer {
        private final Object lock;

        private MyWaitingTimer() {
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long nextWakeup = System.nanoTime();
            while (!this.cancel) {
                long period;
                if (System.nanoTime() >= nextWakeup) {
                    RealTimeTickSource.super.doTick();
                    nextWakeup += RealTimeTickSource.this.interval;
                }
                if ((period = (nextWakeup - System.nanoTime()) / 4L) <= 1000000L) continue;
                period = Math.min(period, 10000000L);
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait(period / 1000000L, (int)(period % 1000000L));
                    }
                }
                catch (InterruptedException ignore) {
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void cancel() {
            super.cancel();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    private class MyBusyTimer
    extends MyTimer {
        private MyBusyTimer() {
        }

        @Override
        public void run() {
            long nextWakeup = System.nanoTime();
            while (!this.cancel) {
                if (System.nanoTime() < nextWakeup) continue;
                RealTimeTickSource.super.doTick();
                nextWakeup += RealTimeTickSource.this.interval;
            }
        }
    }

    private abstract class MyTimer
    implements Runnable {
        protected boolean cancel = false;

        private MyTimer() {
        }

        void cancel() {
            this.cancel = true;
        }
    }
}

