/*
 * Decompiled with CFR 0.152.
 */
package at.borkowski.spicej.proxy;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class RateCalculator {
    public static final float MIN_RATE = 9.4E-10f;
    public static final float MAX_RATE = 3.4009234E38f;
    public static final int NS_PER_S = 1000000000;
    public static final int NS_PER_MS = 1000000;
    public static final int MIN_INTERVAL_NS = 50000000;
    public static final int MAX_INTERVAL_NS = 1000000000;
    public static final long THRESHOLD = (long)Math.ceil(20.0);
    public static final int SCALE = 60;

    private RateCalculator() {
    }

    public static Result calculate(float rateBytesPerSecond) {
        return RateCalculator.calculate(rateBytesPerSecond, 50000000);
    }

    public static Result calculate(float rateBytesPerSecond, int minInterval) {
        int threshold = (int)Math.ceil(1.0E9 / (double)minInterval);
        if (rateBytesPerSecond < 1.0f) {
            BigDecimal interval_ = new BigDecimal(1000000000).divide(new BigDecimal(rateBytesPerSecond), 60, RoundingMode.HALF_UP);
            while (interval_.compareTo(new BigDecimal(1000000000)) > 0) {
                interval_ = interval_.divide(new BigDecimal(2));
            }
            BigDecimal prescale = new BigDecimal(1);
            prescale = prescale.divide(interval_, 60, RoundingMode.HALF_UP);
            prescale = prescale.divide(new BigDecimal(rateBytesPerSecond), 60, RoundingMode.HALF_UP);
            if ((prescale = prescale.multiply(new BigDecimal(1000000000))).compareTo(new BigDecimal(Integer.MAX_VALUE)) > 0) {
                throw new IllegalArgumentException("rate too low (necessary prescale too big)");
            }
            return new Result(1, prescale.intValue(), interval_.intValue());
        }
        if (rateBytesPerSecond < (float)threshold) {
            int interval = (int)(1.0E9f / rateBytesPerSecond);
            return new Result(1, 1, interval);
        }
        int interval = minInterval;
        BigDecimal bytespertick = new BigDecimal(rateBytesPerSecond);
        bytespertick = bytespertick.divide(new BigDecimal(1000000000), 60, RoundingMode.HALF_UP);
        bytespertick = bytespertick.multiply(new BigDecimal(interval));
        return new Result(bytespertick.intValue(), 1, interval);
    }

    public static class Result {
        private final int bytesPerTick;
        private final int prescale;
        private final int tickNanosecondInterval;

        public Result(int bytesPerTick, int prescale, int tickNanosecondInterval) {
            this.bytesPerTick = bytesPerTick;
            this.prescale = prescale;
            this.tickNanosecondInterval = tickNanosecondInterval;
        }

        public int getBytesPerTick() {
            return this.bytesPerTick;
        }

        public int getPrescale() {
            return this.prescale;
        }

        public int getTickNanosecondInterval() {
            return this.tickNanosecondInterval;
        }
    }
}

